/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.coodex.util.Singleton;
import org.coodex.util.SingletonMap;

public class GenericTypeHelper {
    private static SingletonMap<Type, GenericTypeInfo> typeInfos = new SingletonMap<Type, GenericTypeInfo>(new SingletonMap.Builder<Type, GenericTypeInfo>(){

        @Override
        public GenericTypeInfo build(Type key) {
            return new GenericTypeInfo(key);
        }
    });

    public static Type solveFromInstance(TypeVariable t, Object instance) {
        if (instance == null) {
            return t;
        }
        if (instance instanceof Type) {
            return GenericTypeHelper.solveFromType(t, (Type)instance);
        }
        Type result = GenericTypeHelper.solveFromType(t, instance.getClass());
        if (result instanceof TypeVariable) {
            for (Field field : instance.getClass().getDeclaredFields()) {
                if (!field.getName().startsWith("this$")) continue;
                field.setAccessible(true);
                try {
                    Type x = GenericTypeHelper.solveFromInstance((TypeVariable)result, field.get(instance));
                    if (x instanceof TypeVariable) continue;
                    return x;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
        }
        return result;
    }

    public static Type solveFromType(TypeVariable t, Type context) {
        return typeInfos.get(context).find(t);
    }

    @Deprecated
    public static Type solve(TypeVariable t, Object context) {
        if (context instanceof Type) {
            return GenericTypeHelper.solveFromType(t, (Type)context);
        }
        return GenericTypeHelper.solveFromInstance(t, context);
    }

    public static Type toReference(Type t, Type context) {
        return t instanceof TypeVariable ? GenericTypeHelper.solveFromType((TypeVariable)t, context) : GenericTypeHelper.build(t, context);
    }

    public static Class typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static Type buildParameterizedType(Class c, Type ... parameters) {
        return new ParameterizedTypeImpl(c, parameters);
    }

    private static Type build(Type t, Type context) {
        GenericTypeInfo contextInfo = typeInfos.get(context);
        if (t instanceof Class) {
            return t;
        }
        if (t instanceof ParameterizedType) {
            return new ParameterizedTypeImpl(contextInfo, (ParameterizedType)t);
        }
        if (t instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(contextInfo, (GenericArrayType)t);
        }
        if (t instanceof TypeVariable) {
            return contextInfo.find((TypeVariable)t);
        }
        return t;
    }

    private static class GenericTypeInfo {
        private Map<TypeVariable<Class>, Type> map = new ConcurrentHashMap<TypeVariable<Class>, Type>();
        private Set<Type> processed = new HashSet<Type>();

        GenericTypeInfo(Type x) {
            this.process(x);
        }

        Type find(TypeVariable t) {
            Type type = this.map.get(t);
            if (type == null) {
                return t;
            }
            if (type instanceof TypeVariable) {
                return this.find((TypeVariable)type);
            }
            if (type instanceof ParameterizedType) {
                return new ParameterizedTypeImpl(this, (ParameterizedType)type);
            }
            if (type instanceof GenericArrayType) {
                return new GenericArrayTypeImpl(this, (GenericArrayType)type);
            }
            return type;
        }

        private void process(Type x) {
            if (x == null) {
                return;
            }
            if (this.processed.contains(x)) {
                return;
            }
            this.processed.add(x);
            if (x instanceof Class) {
                Class c = (Class)x;
                if (c.isArray()) {
                    this.process(c.getComponentType());
                } else {
                    if (!c.isInterface()) {
                        this.process(c.getGenericSuperclass());
                    }
                    for (Type intf : ((Class)x).getGenericInterfaces()) {
                        this.process(intf);
                    }
                }
            } else if (x instanceof ParameterizedType) {
                Class c = (Class)((ParameterizedType)x).getRawType();
                ParameterizedType pt = (ParameterizedType)x;
                for (int i = 0; i < c.getTypeParameters().length; ++i) {
                    this.map.put(c.getTypeParameters()[i], pt.getActualTypeArguments()[i]);
                }
                this.process(c);
            } else if (x instanceof GenericArrayType) {
                this.process(((GenericArrayType)x).getGenericComponentType());
            }
        }
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type ownerType;
        private final List<Type> actualTypeArguments = new ArrayList<Type>();
        private final Singleton<String> stringSingleton = new Singleton<String>(new Singleton.Builder<String>(){

            @Override
            public String build() {
                StringBuilder builder = new StringBuilder(((Class)ParameterizedTypeImpl.this.getRawType()).getName());
                if (ParameterizedTypeImpl.this.actualTypeArguments.size() > 0) {
                    builder.append("<");
                    for (int i = 0; i < ParameterizedTypeImpl.this.actualTypeArguments.size(); ++i) {
                        Type t;
                        if (i > 0) {
                            builder.append(',');
                        }
                        if ((t = (Type)ParameterizedTypeImpl.this.actualTypeArguments.get(i)) == null) {
                            builder.append("null");
                            continue;
                        }
                        if (t instanceof TypeVariable) {
                            builder.append(((TypeVariable)t).getName()).append(" in ").append(((TypeVariable)t).getGenericDeclaration());
                            continue;
                        }
                        builder.append(t.toString());
                    }
                    builder.append(">");
                }
                return builder.toString();
            }
        });

        ParameterizedTypeImpl(Type rawType, Type ... parameters) {
            this.rawType = rawType;
            this.ownerType = rawType;
            for (Type t : parameters) {
                this.actualTypeArguments.add(t);
            }
        }

        ParameterizedTypeImpl(GenericTypeInfo genericTypeInfo, ParameterizedType pt) {
            this.rawType = pt.getRawType();
            this.ownerType = pt.getOwnerType();
            for (Type t : pt.getActualTypeArguments()) {
                if (t instanceof TypeVariable) {
                    this.actualTypeArguments.add(genericTypeInfo.find((TypeVariable)t));
                    continue;
                }
                if (t instanceof ParameterizedType) {
                    this.actualTypeArguments.add(new ParameterizedTypeImpl(genericTypeInfo, (ParameterizedType)t));
                    continue;
                }
                if (t instanceof GenericArrayType) {
                    this.actualTypeArguments.add(new GenericArrayTypeImpl(genericTypeInfo, (GenericArrayType)t));
                    continue;
                }
                this.actualTypeArguments.add(t);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments.toArray(new Type[0]);
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
            return this.toString().equals(that.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.stringSingleton.get();
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type genericComponentType;

        GenericArrayTypeImpl(GenericTypeInfo genericTypeInfo, GenericArrayType genericArrayType) {
            Type gct = genericArrayType.getGenericComponentType();
            this.genericComponentType = gct instanceof TypeVariable ? genericTypeInfo.find((TypeVariable)gct) : (gct instanceof ParameterizedType ? new ParameterizedTypeImpl(genericTypeInfo, (ParameterizedType)gct) : (gct instanceof GenericArrayType ? new GenericArrayTypeImpl(genericTypeInfo, (GenericArrayType)gct) : gct));
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public String toString() {
            return this.genericComponentType.toString() + "[]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericArrayTypeImpl that = (GenericArrayTypeImpl)o;
            return this.genericComponentType != null ? this.genericComponentType.equals(that.genericComponentType) : that.genericComponentType == null;
        }

        public int hashCode() {
            return this.genericComponentType != null ? this.genericComponentType.hashCode() : 0;
        }
    }

    public static abstract class GenericType<T> {
        private final Type type;

        protected GenericType() {
            this.type = ((GenericTypeInfo)typeInfos.get(this.getClass())).find(GenericType.class.getTypeParameters()[0]);
        }

        protected GenericType(Type context) {
            this.type = this.build(context);
        }

        private Type build(Type context) {
            Type t = ((GenericTypeInfo)typeInfos.get(this.getClass())).find(GenericType.class.getTypeParameters()[0]);
            return GenericTypeHelper.build(t, context);
        }

        public Type getType() {
            return this.type;
        }
    }
}

