/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.Map;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;

public abstract class LazyServiceLoader<T>
implements ServiceLoader<T> {
    private final Singleton<ServiceLoader<T>> singleton;

    public LazyServiceLoader() {
        this(null);
    }

    public LazyServiceLoader(final T defaultProvider) {
        this.singleton = new Singleton(new Singleton.Builder<ServiceLoader<T>>(){

            @Override
            public ServiceLoader<T> build() {
                return new ServiceLoaderImpl<T>(defaultProvider){

                    @Override
                    protected Class<T> getInterfaceClass() {
                        return LazyServiceLoader.this.getInterfaceClass();
                    }
                };
            }
        });
    }

    public LazyServiceLoader(final Singleton.Builder<T> builder) {
        this.singleton = new Singleton(new Singleton.Builder<ServiceLoader<T>>(){

            @Override
            public ServiceLoader<T> build() {
                return new ServiceLoaderImpl<T>(){

                    @Override
                    protected Class<T> getInterfaceClass() {
                        return LazyServiceLoader.this.getInterfaceClass();
                    }

                    @Override
                    public T getDefault() {
                        return builder.build();
                    }
                };
            }
        });
    }

    @Override
    @Deprecated
    public Collection<T> getAllInstances() {
        return this.singleton.get().getAllInstances();
    }

    @Override
    public Map<String, T> getInstances() {
        return this.getAll();
    }

    @Override
    public Map<String, T> getAll() {
        return this.singleton.get().getAll();
    }

    @Override
    public T getInstance(Class<? extends T> providerClass) {
        return this.get(providerClass);
    }

    @Override
    public T get(Class<? extends T> serviceClass) {
        return this.singleton.get().get(serviceClass);
    }

    @Override
    public T getInstance(String name) {
        return this.get(name);
    }

    @Override
    public T get(String name) {
        return this.singleton.get().get(name);
    }

    @Override
    public T getInstance() {
        return this.get();
    }

    @Override
    public T get() {
        return this.singleton.get().get();
    }

    @Override
    public T getDefault() {
        return null;
    }

    @Override
    public T getDefaultProvider() {
        return null;
    }

    protected Class<T> getInterfaceClass() {
        return GenericTypeHelper.typeToClass(GenericTypeHelper.solveFromInstance(LazyServiceLoader.class.getTypeParameters()[0], this));
    }
}

