/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PojoProperty {
    private final Method method;
    private final Field field;
    private final boolean readonly;
    private final Type type;
    private final String name;
    private Annotation[] annotations = null;

    protected PojoProperty(PojoProperty property, Type type) {
        this.method = property == null ? null : property.getMethod();
        this.field = property == null ? null : property.getField();
        this.readonly = property != null && property.isReadonly();
        this.type = type;
        this.name = property == null ? null : property.getName();
    }

    protected PojoProperty(Field field, Type type) {
        this(null, field, Modifier.isFinal(field.getModifiers()), type, field.getName());
    }

    protected PojoProperty(Method method, Field field, boolean readonly, Type type, String name) {
        this.method = method;
        this.field = field;
        this.readonly = readonly;
        this.type = type;
        this.name = name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            return null;
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (T)annotation;
        }
        return null;
    }

    public Annotation findDecoratedBy(Class<? extends Annotation> decoratedClass) {
        if (decoratedClass == null) {
            return null;
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(decoratedClass) == null) continue;
            return annotation;
        }
        return null;
    }

    public List<Annotation> findAllDecoratedBy(Class<? extends Annotation> decoratedClass) {
        if (decoratedClass == null) {
            return null;
        }
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(decoratedClass) == null) continue;
            annotationList.add(annotation);
        }
        return annotationList.size() > 0 ? annotationList : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation[] getAnnotations() {
        PojoProperty pojoProperty = this;
        synchronized (pojoProperty) {
            if (this.annotations == null) {
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
                if (this.method != null) {
                    annotationList.addAll(Arrays.asList(this.method.getAnnotations()));
                }
                if (this.field != null) {
                    annotationList.addAll(Arrays.asList(this.field.getAnnotations()));
                }
                this.annotations = annotationList.toArray(new Annotation[0]);
            }
        }
        return this.annotations;
    }

    public String toString() {
        return "PojoProperty{method=" + this.method + ", field=" + this.field + ", readonly=" + this.readonly + ", type=" + this.type + ", name='" + this.name + '\'' + ", annotations=" + Arrays.toString(this.annotations) + '}';
    }
}

