/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.net.URL;
import org.coodex.util.AbstractProfileProvider;
import org.coodex.util.Profile;
import org.coodex.util.ProfileBaseYaml;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileProviderBaseYaml
extends AbstractProfileProvider {
    private static final Logger log = LoggerFactory.getLogger(ProfileProviderBaseYaml.class);
    private static final String[] SUPPORTED = new String[]{".yml", ".yaml"};
    private static final String YAML_CLASS = "org.yaml.snakeyaml.Yaml";
    private static final Singleton<Boolean> YAML_SUPPORTED = new Singleton<Boolean>(new Singleton.Builder<Boolean>(){

        @Override
        public Boolean build() {
            try {
                Class.forName(ProfileProviderBaseYaml.YAML_CLASS);
                return true;
            }
            catch (ClassNotFoundException e) {
                log.info("{} not found. TODO: support other yaml reader", (Object)ProfileProviderBaseYaml.YAML_CLASS);
                return false;
            }
        }
    });

    @Override
    public String[] getSupported() {
        return SUPPORTED;
    }

    @Override
    public boolean isAvailable() {
        return YAML_SUPPORTED.get();
    }

    @Override
    public Profile get(URL url) {
        return new ProfileBaseYaml(url);
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public boolean accept(URL param) {
        if (param == null || !this.isAvailable()) {
            return false;
        }
        String path = param.toString();
        for (String x : SUPPORTED) {
            if (!path.endsWith(x)) continue;
            return true;
        }
        return false;
    }
}

