/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderProvider;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceLoaderImpl<T>
implements ServiceLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderImpl.class);
    private Singleton<Instances> instances = new Singleton<Instances>(new Singleton.Builder<Instances>(){

        @Override
        public Instances build() {
            Instances instances = new Instances();
            instances.instancesMap = new HashMap();
            java.util.ServiceLoader<ServiceLoaderProvider> serviceLoaderProviders = java.util.ServiceLoader.load(ServiceLoaderProvider.class);
            for (ServiceLoaderProvider provider : serviceLoaderProviders) {
                instances.instancesMap.putAll(provider.load(ServiceLoaderImpl.this.getInterfaceClass()));
            }
            if (instances.instancesMap.size() == 0) {
                log.debug("no ServiceProvider found for [{}], using default provider.", (Object)ServiceLoaderImpl.this.getInterfaceClass().getCanonicalName());
            }
            instances.unmodifiedMap = Collections.unmodifiableMap(instances.instancesMap);
            return instances;
        }
    });
    private T defaultProvider;

    public ServiceLoaderImpl() {
        this(null);
    }

    public ServiceLoaderImpl(T defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    protected Class<T> getInterfaceClass() {
        return GenericTypeHelper.typeToClass(GenericTypeHelper.solveFromInstance(ServiceLoaderImpl.class.getTypeParameters()[0], this));
    }

    @Override
    public T getDefault() {
        if (this.defaultProvider == null) {
            throw new RuntimeException("no provider found for: " + this.getInterfaceClass().getName());
        }
        return this.defaultProvider;
    }

    @Override
    @Deprecated
    public Collection<T> getAllInstances() {
        return this.getAll().values();
    }

    @Override
    public Map<String, T> getAll() {
        return this.instances.get().unmodifiedMap;
    }

    @Override
    public T get(Class<? extends T> providerClass) {
        HashMap copy = new HashMap();
        for (Map.Entry entry : this.instances.get().instancesMap.entrySet()) {
            if (entry.getValue() == null || !providerClass.isAssignableFrom(entry.getValue().getClass())) continue;
            copy.put(entry.getKey(), entry.getValue());
        }
        switch (copy.size()) {
            case 0: {
                if (this.defaultProvider != null && providerClass.isAssignableFrom(this.defaultProvider.getClass())) {
                    return this.defaultProvider;
                }
                return null;
            }
            case 1: {
                return (T)copy.values().iterator().next();
            }
        }
        return this.conflict(providerClass, copy);
    }

    protected T conflict(Class<? extends T> providerClass, Map<String, T> map) {
        T t = this.get(providerClass.getName());
        if (t != null) {
            return t;
        }
        StringBuilder buffer = new StringBuilder(this.getInterfaceClass().getName());
        buffer.append("[providerClass: ").append(providerClass.getName()).append("]");
        buffer.append(" has ").append(map.size()).append(" services:[");
        for (T service : map.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T get(String name) {
        Object instance = this.instances.get().instancesMap.get(name);
        return instance == null ? this.getDefault() : instance;
    }

    protected T conflict() {
        StringBuilder buffer = new StringBuilder(this.getInterfaceClass().getName());
        buffer.append(" has ").append(this.instances.get().instancesMap.size()).append(" services:[");
        for (Object service : this.instances.get().instancesMap.values()) {
            buffer.append("\n\t").append(service.getClass().getName());
        }
        buffer.append("]");
        throw new RuntimeException(buffer.toString());
    }

    @Override
    public T get() {
        if (this.instances.get().instancesMap.size() == 0) {
            return this.getDefault();
        }
        if (this.instances.get().instancesMap.size() == 1) {
            return (T)this.instances.get().instancesMap.values().toArray()[0];
        }
        return this.conflict();
    }

    @Override
    @Deprecated
    public Map<String, T> getInstances() {
        return this.getAll();
    }

    @Override
    @Deprecated
    public T getInstance(Class<? extends T> providerClass) {
        return this.get(providerClass);
    }

    @Override
    @Deprecated
    public T getInstance(String name) {
        return this.get(name);
    }

    @Override
    @Deprecated
    public T getInstance() {
        return this.get();
    }

    @Override
    @Deprecated
    public final T getDefaultProvider() {
        return this.getDefault();
    }

    private class Instances {
        Map<String, T> instancesMap = null;
        Map<String, T> unmodifiedMap = null;

        private Instances() {
        }
    }
}

