/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonMap<K, V> {
    private static final Singleton<ScheduledExecutorService> DEFAULT_SCHEDULED_EXECUTOR_SERVICE = new Singleton<ScheduledExecutorService>(new Singleton.Builder<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService build() {
            return ExecutorsHelper.newSingleThreadScheduledExecutor("singletonMap-DEFAULT");
        }
    });
    private static final Logger log = LoggerFactory.getLogger(SingletonMap.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final Builder<K, V> builder;
    private final Map<K, V> map = new HashMap();
    private final K nullKey;
    private long maxAge = 0L;
    private ScheduledExecutorService scheduledExecutorService;

    public SingletonMap(Builder<K, V> builder) {
        this(builder, 0L, null);
    }

    public SingletonMap(Builder<K, V> builder, long maxAge) {
        this(builder, maxAge, null);
    }

    public SingletonMap(Builder<K, V> builder, long maxAge, ScheduledExecutorService scheduledExecutorService) {
        if (builder == null) {
            throw new NullPointerException("builder MUST NOT be null.");
        }
        this.builder = builder;
        this.nullKey = this.getNullKeyOnce();
        this.maxAge = maxAge;
        if (maxAge > 0L) {
            this.scheduledExecutorService = scheduledExecutorService == null ? DEFAULT_SCHEDULED_EXECUTOR_SERVICE.get() : scheduledExecutorService;
        }
    }

    protected K getNullKeyOnce() {
        return null;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key == null ? this.nullKey : key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(final K key) {
        K finalKey;
        K k = finalKey = key == null ? this.nullKey : key;
        if (!this.map.containsKey(finalKey)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (!this.map.containsKey(finalKey)) {
                    V o = this.builder.build(key);
                    this.map.put(finalKey, o);
                    if (this.maxAge > 0L) {
                        this.scheduledExecutorService.schedule(new Runnable(){

                            @Override
                            public void run() {
                                log.debug("{} die.", key);
                                SingletonMap.this.remove(finalKey);
                            }
                        }, this.maxAge, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
        return this.map.get(finalKey);
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.map.keySet());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public <C extends Collection<V>> C fill(C collection, Collection<K> keys) {
        if (collection == null) {
            throw new NullPointerException("collection is null.");
        }
        if (keys != null && keys.size() > 0) {
            for (Object key : new LinkedHashSet<K>(keys)) {
                collection.add(this.get(key));
            }
        }
        return collection;
    }

    @Deprecated
    public V getInstance(K key) {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        K finalKey;
        K k = finalKey = key == null ? this.nullKey : key;
        if (this.map.containsKey(finalKey)) {
            Map<K, V> map = this.map;
            synchronized (map) {
                if (this.map.containsKey(finalKey)) {
                    return this.map.remove(finalKey);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.map.size() > 0) {
                this.map.clear();
            }
        }
    }

    public static interface Builder<K, V> {
        public V build(K var1);
    }
}

