/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import org.coodex.concurrent.Coalition;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Common;
import org.coodex.util.Singleton;

public abstract class AbstractCoalition<T>
implements Coalition<T> {
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final Coalition.Callback<T> callback;
    protected final int interval;
    private static final Singleton<ScheduledExecutorService> sesSingleton = new Singleton<ScheduledExecutorService>(new Singleton.Builder<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService build() {
            return ExecutorsHelper.newScheduledThreadPool(Common.toInt(System.getProperty("coalition.executors.size"), 3), "CoalitionPool");
        }
    });

    public AbstractCoalition(Coalition.Callback<T> c, int interval, ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            throw new NullPointerException("scheduledExecutorService is null.");
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.callback = c;
        this.interval = interval;
    }

    public AbstractCoalition(Coalition.Callback<T> c, int interval) {
        this(c, interval, sesSingleton.get());
    }
}

