/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.coodex.concurrent.ExecutableWrapper;
import org.coodex.concurrent.ExecutableWrapperImpl;
import org.coodex.util.LazyServiceLoader;

class ExecutorServiceImpl
implements ExecutorService {
    private static LazyServiceLoader<ExecutableWrapper> executableWrapperLoader = new LazyServiceLoader<ExecutableWrapper>((ExecutableWrapper)new ExecutableWrapperImpl()){};
    private final ExecutorService executorService;
    protected final ExecutableWrapper wrapper;

    ExecutorServiceImpl(ExecutorService executorService) {
        this.executorService = executorService;
        this.wrapper = executableWrapperLoader.get();
    }

    <V> Collection<? extends Callable<V>> wrap(Collection<? extends Callable<V>> coll) {
        ArrayList<Callable<V>> list = new ArrayList<Callable<V>>();
        for (Callable<V> c : coll) {
            list.add(this.wrapper.wrap(c));
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(this.wrapper.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(this.wrapper.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(this.wrapper.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(this.wrapper.wrap(command));
    }
}

