/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.coodex.concurrent.ExecutorServiceImpl;
import org.coodex.concurrent.ScheduledExecutorServiceImpl;
import org.coodex.util.ReflectHelper;

final class ExecutorWrapper {
    private static final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    ExecutorWrapper() {
    }

    static <T extends ExecutorService> T wrap(T executorService) {
        executorService = executorService instanceof ScheduledExecutorService ? (ExecutorService)Proxy.newProxyInstance(ScheduledExecutorService.class.getClassLoader(), ReflectHelper.getAllInterfaces(executorService.getClass()), ExecutorWrapper.getInvocationHandlerByType(ScheduledExecutorService.class, executorService, new ScheduledExecutorServiceImpl((ScheduledExecutorService)executorService))) : (ExecutorService)Proxy.newProxyInstance(ExecutorService.class.getClassLoader(), ReflectHelper.getAllInterfaces(executorService.getClass()), ExecutorWrapper.getInvocationHandlerByType(ExecutorService.class, executorService, new ExecutorServiceImpl((ExecutorService)executorService)));
        executors.add((ExecutorService)executorService);
        return executorService;
    }

    static void shutdown() {
        for (ExecutorService service : executors) {
            if (service == null || service.isShutdown() || service.isTerminated()) continue;
            service.shutdown();
        }
    }

    static List<Runnable> shutdownNow() {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        for (ExecutorService service : executors) {
            if (service == null || service.isTerminated()) continue;
            list.addAll(service.shutdownNow());
        }
        return list;
    }

    private static InvocationHandler getInvocationHandlerByType(final Class<? extends ExecutorService> executorClass, final Object origin, final Object impl) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object object;
                Object object2 = object = method.getDeclaringClass().isAssignableFrom(executorClass) ? impl : origin;
                if (args == null || args.length == 0) {
                    return method.invoke(object, new Object[0]);
                }
                return method.invoke(object, args);
            }
        };
    }
}

