/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.coodex.concurrent.ExecutorsHelper;

public class TimeLimitedMap<K, V> {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ScheduledExecutorService scheduledExecutorService;
    private final long timeOut;
    private Map<K, Task<V>> tasks = new ConcurrentHashMap<K, Task<V>>();

    public TimeLimitedMap() {
        this(10000L);
    }

    public TimeLimitedMap(long timeOut) {
        this(timeOut, ExecutorsHelper.newScheduledThreadPool(1, "TLM-life-cycle-" + poolNumber.getAndIncrement()));
    }

    public TimeLimitedMap(long timeOut, ScheduledExecutorService scheduledExecutorService) {
        this.timeOut = timeOut;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void put(K key, V value, TimeoutCallback callback) {
        this.put(key, value, this.timeOut, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(final K key, V value, long timeOut, final TimeoutCallback callback) {
        Task task;
        Map<K, Task<V>> map;
        if (this.tasks.containsKey(key)) {
            map = this.tasks;
            synchronized (map) {
                if (this.tasks.containsKey(key)) {
                    task = this.tasks.remove(key);
                    task.future.cancel(true);
                }
            }
        }
        map = this.tasks;
        synchronized (map) {
            task = new Task();
            task.value = value;
            task.future = this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    Object v = TimeLimitedMap.this.getAndRemove(key);
                    if (v != null && callback != null) {
                        callback.timeout();
                    }
                }
            }, this.getTimeOut(timeOut), TimeUnit.MILLISECONDS);
            this.tasks.put(key, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        Task<V> task = null;
        if (this.tasks.containsKey(key)) {
            Map<K, Task<V>> map = this.tasks;
            synchronized (map) {
                if (this.tasks.containsKey(key)) {
                    task = this.tasks.remove(key);
                }
            }
        }
        if (task != null) {
            task.future.cancel(true);
            return task.value;
        }
        return null;
    }

    private long getTimeOut(long timeOut) {
        return timeOut > 0L ? timeOut : (this.timeOut > 0L ? this.timeOut : 10000L);
    }

    private static class Task<V> {
        ScheduledFuture future;
        V value;

        private Task() {
        }
    }

    public static interface TimeoutCallback {
        public void timeout();
    }
}

