/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.ssl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.coodex.util.Common;

public final class GetCert {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCertificateFromServer(String host, int port, String storePath) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateEncodingException {
        int k;
        SSLContext context = SSLContext.getInstance("SSL");
        SavingTrustManager tm = new SavingTrustManager();
        context.init(null, new TrustManager[]{tm}, new SecureRandom());
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            socket.startHandshake();
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tm.chain == null || tm.chain.length == 0) {
            System.out.println("Could not obtain server certificate chain");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + tm.chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < tm.chain.length; ++i) {
            X509Certificate cert = tm.chain[i];
            System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            System.out.println("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            System.out.println("   sha1    " + GetCert.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("   md5     " + GetCert.toHexString(md5.digest()));
            System.out.println();
        }
        System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String line = reader.readLine().trim();
        try {
            k = line.length() == 0 ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException e) {
            return;
        }
        if (k >= tm.chain.length || k < 0) {
            return;
        }
        X509Certificate cert = tm.chain[k];
        String name = host + "." + port;
        while (storePath.endsWith("/") || storePath.endsWith("\\")) {
            storePath = storePath.substring(0, storePath.length() - 1);
        }
        int index = 0;
        while (GetCert.isExists(storePath + File.separatorChar + name + ".cer")) {
            name = host + "." + port + "-" + ++index;
        }
        File x = Common.getNewFile(storePath + File.separatorChar + name + ".cer");
        FileOutputStream os = new FileOutputStream(x);
        try {
            ((OutputStream)os).write(cert.getEncoded());
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        System.out.println("certificate saved: " + x.getAbsolutePath());
    }

    private static boolean isExists(String name) {
        File f = new File(name);
        return f.exists();
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private X509Certificate[] chain;

        private SavingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
        }
    }
}

