/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import org.coodex.util.Common;
import org.coodex.util.Profile;

public class MIMEHelper {
    private static final Profile mimeTypes = Profile.get("mimeTypes.properties");
    private static final String DEFAULT_TYPE = "application/octet-stream";

    public static String getMimeTypeByFileName(String fileName) {
        if (fileName == null) {
            return DEFAULT_TYPE;
        }
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot >= 0) {
            return MIMEHelper.getMimeTypeByExtName(fileName.substring(indexOfDot + 1));
        }
        return DEFAULT_TYPE;
    }

    public static String getMimeTypeByExtName(String extName) {
        if (extName == null) {
            return DEFAULT_TYPE;
        }
        String mimeType = mimeTypes.getString("mimeType." + extName.toLowerCase());
        return Common.isBlank(mimeType) ? DEFAULT_TYPE : mimeType;
    }
}

