/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.MergedProfile;
import org.coodex.util.ProfileProvider;
import org.coodex.util.ProfileWrapper;
import org.coodex.util.Singleton;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Profile {
    static final Profile NULL_PROFILE = new NullProfile();
    private static final Logger log = LoggerFactory.getLogger(Profile.class);
    private static final LazySelectableServiceLoader<URL, ProfileProvider> PROFILE_PROVIDER_LOADER = new LazySelectableServiceLoader<URL, ProfileProvider>(){};
    private static final Singleton<String[]> ALL_SUPPORTED_FILE_EXT = new Singleton<String[]>(new Singleton.Builder<String[]>(){

        @Override
        public String[] build() {
            Object[] profileProviders = PROFILE_PROVIDER_LOADER.getAll().values().toArray(new ProfileProvider[0]);
            Arrays.sort(profileProviders);
            ArrayList<String> list = new ArrayList<String>();
            for (Object profileProvider : profileProviders) {
                if (!profileProvider.isAvailable()) continue;
                list.addAll(Arrays.asList(profileProvider.getSupported()));
            }
            return list.toArray(new String[0]);
        }
    });
    private static final URL DEFAULT_URL;
    private static final SingletonMap<String, Profile> WRAPPER_PROFILES;
    private static final Singleton<Long> RELOAD_INTERVAL_SINGLETON;
    private static final SingletonMap<String, URL> PROFILE_URLS;
    private static final SingletonMap<URL, Profile> URL_PROFILES_MAP;

    public static String[] allSupportedFileExt() {
        return ALL_SUPPORTED_FILE_EXT.get();
    }

    public static Profile get(URL url) {
        return URL_PROFILES_MAP.get(url);
    }

    static Profile getByPath(String path) {
        return Profile.get(PROFILE_URLS.get(path));
    }

    public static Profile get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        return WRAPPER_PROFILES.get(path);
    }

    public static Profile get(String path1, String path2, String ... others) {
        return new MergedProfile(path1, path2, others);
    }

    @Deprecated
    public static Profile getProfile(URL url) {
        return Profile.get(url);
    }

    @Deprecated
    public static Profile getProfile(String path) {
        return Profile.get(path);
    }

    public boolean getBool(String key, boolean v) {
        return Common.toBool(this.getString(key), v);
    }

    public boolean getBool(String key) {
        return this.getBool(key, false);
    }

    protected abstract String getStringImpl(String var1);

    protected abstract boolean isNull(String var1);

    private boolean isPlaceHolder(String v) {
        return v.startsWith("${") && v.endsWith("}");
    }

    private String actualValue(String v) {
        if (this.isPlaceHolder(v)) {
            String x = v.substring(2, v.length() - 1);
            int index = x.indexOf(58);
            String namespace = null;
            String key = x;
            if (index > 0) {
                namespace = x.substring(0, index);
                key = x.substring(index + 1);
            }
            Profile profile = namespace == null ? this : Profile.get(namespace);
            return profile.getString(key);
        }
        return v;
    }

    public String getString(String key, Common.Supplier<String> supplier) {
        String s = this.getStringImpl(key);
        return s == null ? supplier.get() : this.actualValue(s);
    }

    public String getString(String key, String v) {
        String s = this.getStringImpl(key);
        return s == null ? v : this.actualValue(s);
    }

    public String getString(String key) {
        return this.getString(key, (String)null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, Common.Supplier<Integer> v) {
        return Common.toInt(this.getString(key), v);
    }

    public int getInt(String key, int v) {
        return Common.toInt(this.getString(key), v);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long v) {
        return Common.toLong(this.getString(key), v);
    }

    public long getLong(String key, Common.Supplier<Long> v) {
        return Common.toLong(this.getString(key), v);
    }

    public String[] getStrList(String key) {
        return this.getStrList(key, ",");
    }

    public String[] getStrList(String key, String delim) {
        return this.getStrList(key, delim, (String[])null);
    }

    public String[] getStrList(String key, String delim, Common.Supplier<String[]> supplier) {
        return Common.toArray(this.getString(key), delim, supplier);
    }

    public String[] getStrList(String key, Common.Supplier<String[]> supplier) {
        return Common.toArray(this.getString(key), ",", supplier);
    }

    public String[] getStrList(String key, String delim, String[] v) {
        return Common.toArray(this.getString(key), delim, v);
    }

    static {
        WRAPPER_PROFILES = new SingletonMap<String, Profile>(new SingletonMap.Builder<String, Profile>(){

            @Override
            public Profile build(String key) {
                return new ProfileWrapper(key);
            }
        });
        RELOAD_INTERVAL_SINGLETON = new Singleton<Long>(new Singleton.Builder<Long>(){

            @Override
            public Long build() {
                return (Long)((Object)Config.BASE_SYSTEM_PROPERTIES.getValue(Profile.class.getName() + ".reloadInterval", new Common.Supplier<Long>(){

                    @Override
                    public Long get() {
                        return Common.toLong(System.getProperty("Profile.reloadInterval"), 0L);
                    }
                }, new String[0])) * 1000L;
            }
        });
        PROFILE_URLS = new SingletonMap<String, URL>(new SingletonMap.Builder<String, URL>(){

            @Override
            public URL build(String key) {
                String[] ex;
                for (String s : ex = Profile.allSupportedFileExt()) {
                    URL x;
                    if (key.endsWith(s) && (x = Common.getResource(key, new ClassLoader[0])) != null) {
                        return x;
                    }
                    x = Common.getResource(key + s, new ClassLoader[0]);
                    if (x == null) continue;
                    return x;
                }
                if (log.isInfoEnabled()) {
                    StringBuilder builder = new StringBuilder("Profile ").append(key).append(" not found.[");
                    for (int i = 0; i < ex.length; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        builder.append("'").append(ex[i]).append("'");
                    }
                    builder.append("]");
                    log.info(builder.toString());
                }
                return DEFAULT_URL;
            }
        }, RELOAD_INTERVAL_SINGLETON.get());
        URL_PROFILES_MAP = new SingletonMap<URL, Profile>(new SingletonMap.Builder<URL, Profile>(){

            @Override
            public Profile build(URL key) {
                if (key == null) {
                    throw new NullPointerException("profile url could not be null.");
                }
                if (DEFAULT_URL.equals(key)) {
                    return NULL_PROFILE;
                }
                ProfileProvider profileProvider = (ProfileProvider)PROFILE_PROVIDER_LOADER.select(key);
                if (profileProvider == null) {
                    return NULL_PROFILE;
                }
                return profileProvider.get(key);
            }
        }, RELOAD_INTERVAL_SINGLETON.get());
        try {
            DEFAULT_URL = new URL("file:/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private static class NullProfile
    extends Profile {
        private NullProfile() {
        }

        @Override
        protected String getStringImpl(String key) {
            return null;
        }

        @Override
        protected boolean isNull(String key) {
            return true;
        }
    }
}

