/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Section<T extends Comparable<T>> {
    private T start;
    private T end;

    protected Section(T start, T end) {
        if (start == null) {
            throw new NullPointerException("start is null");
        }
        if (end == null) {
            throw new NullPointerException("end is null");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("start > end");
        }
        this.start = this.cloneObject(start);
        this.end = this.cloneObject(end);
    }

    public static <T extends Comparable<T>, S extends Section<T>> List<S> merge(List<S> sections, Builder<T, S> builder) {
        S section;
        if (sections == null || sections.size() == 0) {
            return new ArrayList();
        }
        ArrayList<S> periodList = new ArrayList<S>(sections);
        Collections.sort(periodList, new Comparator<S>(){

            @Override
            public int compare(S o1, S o2) {
                return ((Section)o1).getStart().compareTo(((Section)o2).getStart());
            }
        });
        ArrayList<S> resultList = new ArrayList<S>();
        int index = 0;
        while (((Section)(section = builder.create(((Section)periodList.get(index)).getStart(), ((Section)periodList.get(index)).getEnd()))).getStart().equals(((Section)section).getEnd()) && ++index < periodList.size()) {
        }
        if (((Section)section).getStart().equals(((Section)section).getEnd())) {
            return new ArrayList();
        }
        resultList.add(section);
        for (int i = index; i < periodList.size(); ++i) {
            Section periodToMerge = (Section)periodList.get(i);
            if (((Section)section).getEnd().compareTo(periodToMerge.getEnd()) >= 0) continue;
            if (((Section)section).getEnd().compareTo(periodToMerge.getStart()) < 0) {
                if (periodToMerge.getStart().equals(periodToMerge.getEnd())) continue;
                section = builder.create(periodToMerge.getStart(), periodToMerge.getEnd());
                resultList.add(section);
                continue;
            }
            ((Section)section).setEnd(periodToMerge.getEnd());
        }
        return resultList;
    }

    public static <T extends Comparable<T>, S extends Section<T>> List<S> intersect(List<S> s1, List<S> s2, Builder<T, S> builder) {
        if (s1 == null || s1.size() == 0 || s2 == null || s2.size() == 0) {
            return new ArrayList();
        }
        List<S> union = Section.merge(s1, builder);
        union.addAll(Section.merge(s2, builder));
        return Section.sub(Section.sub(Section.merge(union, builder), Section.sub(s1, s2, builder), builder), Section.sub(s2, s1, builder), builder);
    }

    public static <T extends Comparable<T>, S extends Section<T>> List<S> sub(List<S> subtractedList, List<S> subtractionList, Builder<T, S> builder) {
        if (subtractedList == null) {
            throw new RuntimeException("Subtracted Periods must not be null");
        }
        if (subtractedList.size() == 0) {
            return subtractedList;
        }
        List<Section> subtracted = Section.merge(subtractedList, builder);
        if (subtractionList == null || subtractionList.size() == 0) {
            return subtracted;
        }
        List<S> subtraction = Section.merge(subtractionList, builder);
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Section subtractedSection : subtracted) {
            sections.addAll(Section.sub(subtractedSection, subtraction, builder));
        }
        return sections;
    }

    private static <T extends Comparable<T>, S extends Section<T>> List<S> sub(S subtractedSection, List<S> subtraction, Builder<T, S> builder) {
        Section subtractionSection;
        ArrayList<S> result = new ArrayList<S>();
        boolean crossed = false;
        Iterator<S> iterator = subtraction.iterator();
        while (iterator.hasNext() && (subtractionSection = (Section)iterator.next()).getStart().compareTo(subtractedSection.getEnd()) < 0) {
            if (subtractionSection.getEnd().compareTo(subtractedSection.getStart()) <= 0) continue;
            crossed = true;
            if (subtractedSection.getStart().compareTo(subtractionSection.getStart()) < 0) {
                result.add(builder.create(subtractedSection.getStart(), subtractionSection.getStart()));
            }
            if (subtractedSection.getEnd().compareTo(subtractionSection.getEnd()) <= 0) continue;
            result.addAll(Section.sub(builder.create(subtractionSection.getEnd(), subtractedSection.getEnd()), subtraction, builder));
            break;
        }
        if (!crossed) {
            result.add(subtractedSection);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "{start=" + this.start + ", end=" + this.end + '}';
    }

    protected T cloneObject(T t) {
        return t;
    }

    public T getStart() {
        return this.cloneObject(this.start);
    }

    public T getEnd() {
        return this.cloneObject(this.end);
    }

    void setEnd(T end) {
        this.end = this.cloneObject(end);
    }

    public static interface Builder<T extends Comparable<T>, S extends Section<T>> {
        public S create(T var1, T var2);
    }
}

