/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

public class Singleton<T> {
    private Builder<T> builder;
    private volatile T instance = null;
    private volatile boolean loaded = false;

    Singleton() {
    }

    public Singleton(Builder<T> builder) {
        this.setBuilder(builder);
    }

    private void setBuilder(Builder<T> builder) {
        if (builder == null) {
            throw new NullPointerException("builder MUST NOT be null.");
        }
        this.builder = builder;
    }

    @Deprecated
    public T getInstance() {
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.loaded) {
            Singleton singleton = this;
            synchronized (singleton) {
                if (!this.loaded) {
                    this.instance = this.builder.build();
                    this.loaded = true;
                }
            }
        }
        return this.instance;
    }

    public static interface Builder<T> {
        public T build();
    }
}

