/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.clock;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.coodex.util.clock.AbstractClockAgent;
import org.coodex.util.clock.ClockAgentService;

public class RemoteClockAgent
extends AbstractClockAgent {
    public static final String KEY_REMOTE_HOST = Clock.class.getName() + ".remoteHost";
    public static final String KEY_REMOTE_PORT = Clock.class.getName() + ".remotePort";
    private static Singleton<Configuration> configurationSingleton = new Singleton<Configuration>(new Singleton.Builder<Configuration>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Configuration build() {
            Configuration configuration;
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.getHost(), this.getPort()));
            try {
                int count;
                byte[] buf = new byte[20];
                int offset = 0;
                do {
                    if ((count = socket.getInputStream().read(buf, offset, buf.length - offset)) != -1) continue;
                    throw new RuntimeException("received error");
                } while ((offset += count) < buf.length);
                Configuration configuration2 = new Configuration();
                ByteBuffer buffer = ByteBuffer.wrap(buf);
                configuration2.start = buffer.getLong(0);
                configuration2.baseLine = buffer.getLong(8);
                configuration2.magnification = Float.valueOf(buffer.getFloat(16));
                configuration = configuration2;
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            socket.close();
            return configuration;
        }

        private String getHost() {
            String host = Config.get(KEY_REMOTE_HOST, "clock");
            return host == null ? System.getProperty(KEY_REMOTE_HOST) : host;
        }

        private int getPort() {
            String port = Config.get(KEY_REMOTE_PORT, "clock");
            if (port != null) {
                return Common.toInt(port, ClockAgentService.PORT);
            }
            return Common.toInt(System.getProperty(KEY_REMOTE_PORT), ClockAgentService.PORT);
        }
    });

    public RemoteClockAgent() {
        super(RemoteClockAgent.configurationSingleton.get().magnification, RemoteClockAgent.configurationSingleton.get().baseLine, RemoteClockAgent.configurationSingleton.get().start);
    }

    static class Configuration {
        Float magnification;
        long baseLine;
        long start;

        Configuration() {
        }
    }
}

