/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.concurrent.FrequencyReducer;

public class Debounce
implements FrequencyReducer {
    private final ScheduledExecutorService scheduledExecutorService;
    private final long idle;
    private final Runnable runnable;
    private final ReentrantLock lock = new ReentrantLock();
    private ScheduledFuture<?> prevFuture;

    private Debounce(Builder builder) {
        this.idle = Math.max(0L, builder.idle);
        this.runnable = builder.runnable;
        this.scheduledExecutorService = builder.scheduledExecutorService == null ? (ScheduledExecutorService)DEFAULT_REDUCER_EXECUTOR_SERVICE_SINGLETON.get() : builder.scheduledExecutorService;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void submit() {
        this.submit(this.runnable);
    }

    @Override
    public void submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable instance is null.");
        }
        this.lock.lock();
        try {
            if (this.prevFuture != null) {
                this.prevFuture.cancel(false);
            }
            this.prevFuture = this.scheduledExecutorService.schedule(() -> {
                this.lock.lock();
                try {
                    runnable.run();
                }
                finally {
                    this.prevFuture = null;
                    this.lock.unlock();
                }
            }, this.idle, TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        if (this.prevFuture != null) {
            this.lock.lock();
            try {
                if (this.prevFuture != null) {
                    this.prevFuture.cancel(false);
                    this.prevFuture = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class Builder {
        private long idle = 100L;
        private ScheduledExecutorService scheduledExecutorService;
        private Runnable runnable;

        private Builder() {
        }

        public Builder idle(long idle) {
            this.idle = idle;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder runnable(Runnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Debounce build() {
            return new Debounce(this);
        }
    }
}

