/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.locks;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.concurrent.locks.AbstractResourceLock;
import org.coodex.concurrent.locks.ResourceId;
import org.coodex.concurrent.locks.ResourceLock;
import org.coodex.concurrent.locks.ResourceLockProvider;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceLockProvider
implements ResourceLockProvider {
    public static final long RESOURCE_CACHE_MAX_LIFE = 10000L;
    public static final long POLLING_CYCLE = 5000L;
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceLockProvider.class);
    private static final AbstractResourceLock[] toArraysParam = new AbstractResourceLock[0];
    private static final Comparator<AbstractResourceLock> comparator = (o1, o2) -> (int)(o1.getLastActive() - o2.getLastActive());
    private static final Singleton<ScheduledExecutorService> scheduledExecutorServiceSingleton = Singleton.with(() -> ExecutorsHelper.newSingleThreadScheduledExecutor("cleanDeathResource"));
    protected final Map<ResourceId, AbstractResourceLock> locksMap = new HashMap<ResourceId, AbstractResourceLock>(8);
    private final Runnable cleanRunner = () -> {
        try {
            this.cleanDeathResource();
        }
        finally {
            this.poll();
        }
    };

    protected abstract AbstractResourceLock buildResourceLock(ResourceId var1);

    public AbstractResourceLockProvider() {
        this.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceLock getLock(ResourceId id) {
        Map<ResourceId, AbstractResourceLock> map = this.locksMap;
        synchronized (map) {
            if (!this.locksMap.containsKey(id)) {
                this.locksMap.put(id, this.buildResourceLock(id));
            }
            return this.locksMap.get(id).active();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDeathResource() {
        if (this.locksMap.size() == 0) {
            return;
        }
        Map<ResourceId, AbstractResourceLock> map = this.locksMap;
        synchronized (map) {
            StringBuilder builder = new StringBuilder();
            if (log.isDebugEnabled()) {
                builder.append(this.getClass().getName()).append(" before clean: ").append(this.locksMap.size()).append(" resource(s)");
            }
            int count = 0;
            AbstractResourceLock[] locks = this.locksMap.values().toArray(toArraysParam);
            Arrays.sort(locks, comparator);
            for (AbstractResourceLock lock : locks) {
                if (!lock.isDeath()) break;
                this.locksMap.remove(lock.getId());
                ++count;
            }
            if (log.isDebugEnabled() && count > 0) {
                builder.append("\n\tafter clean: ").append(this.locksMap.size()).append(" resource(s).");
                log.debug(builder.toString());
            }
        }
    }

    protected void poll() {
        scheduledExecutorServiceSingleton.get().schedule(this.cleanRunner, 5000L, TimeUnit.MILLISECONDS);
    }
}

