/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.coodex.util.Clock;
import org.coodex.util.DigestHelper;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.ResourceScanner;
import org.coodex.util.SelectableServiceLoader;
import org.coodex.util.SingletonMap;
import org.coodex.util.StringConvertWithDefaultValue;
import org.coodex.util.UUIDHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final Long SYSTEM_START_TIME = ManagementFactory.getRuntimeMXBean().getStartTime();
    public static final int PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(Common.class);
    private static final int TO_LOWER = 32;
    private static final String DEFAULT_DELIM = ".-_ /\\";
    private static final ThreadLocal<SingletonMap<String, DateFormat>> threadLocal = new ThreadLocal();
    private static final SelectableServiceLoader<Class<?>, StringConvertWithDefaultValue> converterServiceLoader = new LazySelectableServiceLoader<Class<?>, StringConvertWithDefaultValue>(){};
    private static final char[] BASE16_CHAR = "0123456789abcdef".toCharArray();

    private Common() {
    }

    private static long i2l(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static boolean isWindows() {
        return PATH_SEPARATOR.equals(";");
    }

    private static String[] userDir() {
        return USER_DIR.split(Common.isWindows() ? "\\\\" : "/");
    }

    public static String toAbsolutePath(String path) {
        return Common.isWindows() ? Common.toAbsolutePathWindows(path) : Common.toAbsolutePathUnixLike(path);
    }

    private static String toAbsolutePathUnixLike(String path) {
        String[] pathNodes = path.replace('\\', '/').split("/");
        if (pathNodes.length > 0 && Common.isBlank(pathNodes[0])) {
            return path;
        }
        return Common.getAbsolutePath(pathNodes);
    }

    private static String toAbsolutePathWindows(String path) {
        String[] pathNodes = path.replace('/', '\\').split("\\\\");
        if (pathNodes.length > 0 && pathNodes[0].indexOf(58) > 0) {
            return path;
        }
        return Common.getAbsolutePath(pathNodes);
    }

    private static String getAbsolutePath(String[] pathNodes) {
        int x;
        String[] userDirNodes = Common.userDir();
        int i = 0;
        int userDirNodesIndex = userDirNodes.length - 1;
        if (Common.isBlank(pathNodes[0])) {
            StringJoiner joiner = new StringJoiner(FILE_SEPARATOR);
            joiner.add(userDirNodes[0]);
            for (int j = 1; j < pathNodes.length; ++j) {
                joiner.add(pathNodes[j]);
            }
            return joiner.toString();
        }
        while (i < pathNodes.length) {
            if (pathNodes[i].equals(".")) {
                ++i;
                continue;
            }
            if (!pathNodes[i].equals("..")) break;
            userDirNodesIndex = Math.max(0, userDirNodesIndex - 1);
            ++i;
        }
        StringJoiner joiner = new StringJoiner(FILE_SEPARATOR);
        for (x = 0; x <= userDirNodesIndex; ++x) {
            joiner.add(userDirNodes[x]);
        }
        x = i;
        while (i < pathNodes.length) {
            joiner.add(pathNodes[i]);
            ++i;
        }
        return joiner.toString();
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        return Arrays.stream(Objects.requireNonNull(array, "array MUST NOT null")).collect(Collectors.toSet());
    }

    @Deprecated
    public static String getUUIDStr() {
        return UUIDHelper.getUUIDString();
    }

    public static String sha1(String content) {
        return Common.sha1(content, StandardCharsets.UTF_8);
    }

    public static String sha1(String content, Charset charset) {
        byte[] buf = content == null ? new byte[]{} : content.getBytes(charset);
        return DigestHelper.sha1(buf);
    }

    public static <T> boolean inArray(T el, T[] array) {
        return Common.indexOf(array, el) >= 0;
    }

    @Deprecated
    public static <T> int findInArray(T el, T[] array) {
        return Common.indexOf(array, el);
    }

    public static String nullToStr(String str) {
        return str == null ? "" : str;
    }

    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(object);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static Object deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));){
            Object object = ois.readObject();
            return object;
        }
    }

    public static <T extends Serializable> T deepCopy(T object) throws IOException, ClassNotFoundException {
        return (T)((Serializable)Common.cast(Common.deserialize(Common.serialize(object))));
    }

    public static int random(int max) {
        return (int)Common.random(0L, Common.i2l(max));
    }

    public static int randomC(int max) {
        return (int)Common.random(0L, (long)max + 1L);
    }

    public static int random(int min, int max) {
        return (int)Common.random(Common.i2l(min), Common.i2l(max));
    }

    public static int randomC(int min, int max) {
        return (int)Common.random(Common.i2l(min), (long)max + 1L);
    }

    public static long random(long min, long max) {
        return Common.random(min, max, false);
    }

    public static long random(long max) {
        return Common.random(0L, max);
    }

    public static long randomC(long max) {
        return Common.random(0L, max, true);
    }

    public static long randomC(long min, long max) {
        return Common.random(min, max, true);
    }

    private static long random(long bound1, long bound2, boolean includeMax) {
        long max;
        long min = Math.min(bound1, bound2);
        if (min == (max = Math.max(bound1, bound2))) {
            return min;
        }
        long step = max - min + (includeMax ? 1L : 0L);
        if (step > 0L) {
            return min + (long)(Math.random() * (double)step);
        }
        return Math.random() < (double)Math.abs(min) * 1.0 / (double)max ? Common.random(min, 0L, includeMax) : Common.random(0L, max, includeMax);
    }

    public static double random(double min, double max) {
        if (min == max) {
            return min;
        }
        double _min = Math.min(min, max);
        double _max = Math.max(min, max);
        return _min + Math.random() * (_max - _min);
    }

    public static <K extends Serializable, V extends Serializable> void copyMap(Map<K, V> org, Map<K, V> target) {
        for (Serializable key : org.keySet()) {
            try {
                target.put(Common.deepCopy(key), Common.deepCopy((Serializable)org.get(key)));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        Common.copyStream(is, os, 4096, false, Integer.MAX_VALUE);
    }

    public static void copyStream(InputStream is, OutputStream os, int blockSize, boolean flushPerBlock, int bps) throws IOException {
        int cached;
        byte[] buf = new byte[blockSize];
        long start = Clock.currentTimeMillis();
        long wrote = 0L;
        while ((cached = is.read(buf)) > 0) {
            if (wrote >= (long)bps) {
                long n = wrote / (long)bps;
                wrote %= (long)bps;
                long interval = Clock.currentTimeMillis() - start;
                try {
                    if (interval < 1000L * n) {
                        Clock.sleep(interval);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            start = Clock.currentTimeMillis();
            os.write(buf, 0, cached);
            if (!flushPerBlock) continue;
            os.flush();
            wrote += (long)cached;
        }
        if (!flushPerBlock) {
            os.flush();
        }
    }

    @Deprecated
    public static void checkNull(Object o, String msg) {
        Objects.requireNonNull(o, msg);
    }

    private static <T extends Comparable<T>> T _max(T c1, T c2) {
        return c1.compareTo(c2) >= 0 ? c1 : c2;
    }

    @Deprecated
    public static <T extends Comparable<T>> boolean between(T t, T bound1, T bound2) {
        return Edge.OPEN_OPEN.between(t, bound1, bound2);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T c1, T c2, T ... others) {
        Objects.requireNonNull(c1, "c1 is null");
        Objects.requireNonNull(c2, "c2 is null");
        T currentMax = Common._max(c1, c2);
        if (others != null && others.length > 0) {
            int len = others.length;
            for (int i = 0; i < len; ++i) {
                Objects.requireNonNull(others[i], "c" + (i + 3) + " is null");
                currentMax = Common._max(currentMax, others[i]);
            }
        }
        return currentMax;
    }

    private static <T extends Comparable<T>> T _min(T c1, T c2) {
        return c1.compareTo(c2) <= 0 ? c1 : c2;
    }

    @Deprecated
    public static String byte2hex(byte[] b) {
        return Common.base16Encode(b);
    }

    @Deprecated
    public static String byte2hex(byte[] b, int offset, int length) {
        return Common.base16Encode(b, offset, length);
    }

    @Deprecated
    public static String byte2hex(byte[] b, int col, String split) {
        return Common.base16Encode(b, col, split);
    }

    @Deprecated
    public static String byte2hex(byte[] b, int offset, int length, int col, String split) {
        return Common.base16Encode(b, offset, length, col, split);
    }

    public static String base16Encode(byte[] b) {
        return Common.base16Encode(b, 0, b.length);
    }

    public static String base16Encode(byte[] b, int offset, int length) {
        return Common.base16Encode(b, offset, length, Integer.MAX_VALUE, null);
    }

    public static String base16Encode(byte[] b, int col, String split) {
        return Common.base16Encode(b, line -> col, split);
    }

    public static String base16Encode(byte[] b, Function<Integer, Integer> colFunction, String split) {
        return Common.base16Encode(b, 0, b.length, colFunction, split);
    }

    public static String base16Encode(byte[] b, int offset, int length, int col, String split) {
        return Common.base16Encode(b, offset, length, line -> col, split);
    }

    private static String encodeByte(byte b) {
        int temp = b & 0xFF;
        return new String(new char[]{BASE16_CHAR[temp >> 4 & 0xF], BASE16_CHAR[temp & 0xF]});
    }

    public static String base16Encode(byte[] b, int offset, int length, Function<Integer, Integer> colFunction, String split) {
        StringBuilder builder = new StringBuilder();
        boolean blankSplit = split == null || "".equals(split);
        int line = 0;
        int index = offset;
        int remain = length;
        while (remain > 0) {
            if (line > 0) {
                builder.append(LINE_SEPARATOR);
            }
            int col = colFunction.apply(line++);
            int encodeCountForThisLine = Math.min(remain, col);
            remain -= encodeCountForThisLine;
            boolean firstByte = true;
            while (encodeCountForThisLine > 0) {
                --encodeCountForThisLine;
                if (!firstByte && !blankSplit) {
                    builder.append(split);
                } else {
                    firstByte = false;
                }
                builder.append(Common.encodeByte(b[index++]));
            }
        }
        return builder.toString();
    }

    public static <T> String formatArray(T[] array, int offset, int length, Function<Integer, Integer> colFunction, String split, Function<T, String> encoder) {
        StringBuilder builder = new StringBuilder();
        boolean blankSplit = split == null || "".equals(split);
        int line = 0;
        int index = offset;
        int remain = length;
        while (remain > 0) {
            if (line > 0) {
                builder.append(LINE_SEPARATOR);
            }
            int col = colFunction.apply(line++);
            int encodeCountForThisLine = Math.min(remain, col);
            remain -= encodeCountForThisLine;
            boolean firstByte = true;
            while (encodeCountForThisLine > 0) {
                --encodeCountForThisLine;
                if (!firstByte && !blankSplit) {
                    builder.append(split);
                } else {
                    firstByte = false;
                }
                builder.append(encoder.apply(array[index++]));
            }
        }
        return builder.toString();
    }

    private static int hexCharValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Deprecated
    public static byte[] hex2byte(String hexString) {
        return Common.base16Decode(hexString);
    }

    @Deprecated
    public static byte[] hex2byte(String hexString, String ignoreChars) {
        return Common.base16Decode(hexString, ignoreChars);
    }

    public static byte[] base16Decode(String hexString) {
        return Common.base16Decode(hexString, LINE_SEPARATOR + " ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] base16Decode(String hexString, String ignoreChars) {
        char[] ignore = ignoreChars == null ? new char[]{} : ignoreChars.toCharArray();
        int hi = -1;
        int low = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (char c : hexString.toCharArray()) {
            boolean closed;
            int charValue = Common.hexCharValue(c);
            if (charValue == -1) {
                if (!Common.inArray(c, ignore)) throw new RuntimeException("unknown hex char: " + c + "[0x" + Integer.toHexString(c) + "]");
                closed = true;
            } else {
                hi = low;
                low = charValue;
                boolean bl = closed = hi != -1;
            }
            if (!closed || low == -1) continue;
            byteArrayOutputStream.write(hi == -1 ? low : hi << 4 | low);
            hi = -1;
            low = -1;
        }
        if (low == -1) return byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.write(hi == -1 ? low : hi << 4 | low);
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> difference(Set<T> org, Set<T> todiv) {
        HashSet<T> result = new HashSet<T>(org);
        result.removeAll(todiv);
        return result;
    }

    @SafeVarargs
    private static <T, C extends Collection<T>> C join(C instance, Collection<? extends T> ... collections) {
        if (collections != null && collections.length > 0) {
            for (Collection<T> collection : collections) {
                if (collection == null) continue;
                instance.addAll(collection);
            }
        }
        return instance;
    }

    @SafeVarargs
    public static <T> Set<T> join(Collection<T> ... sets) {
        return Common.join(new HashSet(), sets);
    }

    public static String native2AscII(String str) {
        if (str == null) {
            return null;
        }
        char[] charPoints = str.toCharArray();
        StringBuilder strBuf = new StringBuilder();
        for (char ch : charPoints) {
            if (ch < '\u0100') {
                strBuf.append(ch);
                continue;
            }
            strBuf.append("\\u").append(Integer.toHexString(ch));
        }
        return strBuf.toString();
    }

    @Deprecated
    public static File getNewFile(String fileName) throws IOException {
        return Common.newFile(fileName);
    }

    public static File newFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        return f;
    }

    public static URL getResource(String resource, ClassLoader ... classLoaders) {
        URL url;
        resource = Common.trim(resource, '/');
        for (String path : ResourceScanner.getExtraResourcePath()) {
            String filePath = path + FILE_SEPARATOR + resource;
            File file = new File(filePath);
            if (!file.exists()) continue;
            try {
                return new URL(filePath);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        if (classLoaders != null && classLoaders.length > 0) {
            for (ClassLoader cl : classLoaders) {
                url = cl.getResource(resource);
                if (url == null) continue;
                return url;
            }
        }
        if ((classLoader = Common.class.getClassLoader()) != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            throw new NullPointerException("indexOf: array must not be NULL.");
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(t == null ? array[i] == null : t.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String concat(Collection<String> list, String split) {
        if (list == null) {
            return null;
        }
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return list.iterator().next();
            }
        }
        StringJoiner joiner = new StringJoiner(split);
        list.forEach(joiner::add);
        return joiner.toString();
    }

    public static <T> T to(String str, T value) {
        if (value == null) {
            if (str == null) {
                return null;
            }
            throw new NullPointerException("value is null.");
        }
        Class<?> cls = value.getClass();
        if (cls.equals(String.class)) {
            return Common.cast(str == null ? value : str);
        }
        if (cls.isArray() && cls.getComponentType().equals(String.class)) {
            return Common.cast(Common.toArray(str, ",", (String[])value));
        }
        StringConvertWithDefaultValue defaultValue = converterServiceLoader.select(cls);
        if (defaultValue == null) {
            throw new RuntimeException("String to " + cls + " is not supported.");
        }
        return Common.cast(defaultValue.convertTo(str, value, cls));
    }

    public static int toInt(String str, Supplier<Integer> valueSupplier) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable th) {
            return valueSupplier.get();
        }
    }

    public static int toInt(String str, int value) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static long toLong(String str, Supplier<Long> value) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable th) {
            return value.get();
        }
    }

    public static long toLong(String str, long value) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable th) {
            return value;
        }
    }

    public static boolean toBool(String str, Supplier<Boolean> v) {
        String s = Common.nullToStr(str);
        if (s.equals("1") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        return v.get();
    }

    public static boolean toBool(String str, boolean v) {
        String s = Common.nullToStr(str);
        if (s.equals("1") || s.equalsIgnoreCase("T") || s.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.equalsIgnoreCase("F") || s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        return v;
    }

    public static List<String> toArray(String str, String delim, List<String> v) {
        if (Common.isBlank(str)) {
            return v;
        }
        StringTokenizer st = new StringTokenizer(str, delim, false);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreElements()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static String[] toArray(String str, String delim, Supplier<String[]> v) {
        List<String> list = Common.toArray(str, delim, (List<String>)null);
        return list == null ? v.get() : list.toArray(new String[0]);
    }

    public static String[] toArray(String str, String delim, String[] v) {
        List<String> list = Common.toArray(str, delim, (List<String>)null);
        return list == null ? v : list.toArray(new String[0]);
    }

    private static boolean inArray(char ch, char[] chars) {
        for (char c : chars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str, char ... trimChars) {
        int start;
        if (Common.isBlank(str) || trimChars == null || trimChars.length == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int end = chars.length;
        for (start = 0; start < end && Common.inArray(chars[start], trimChars); ++start) {
        }
        while (end > start && Common.inArray(chars[end - 1], trimChars)) {
            --end;
        }
        return new String(chars, start, end - start);
    }

    public static String trim(String str, String toTrim) {
        if (Common.isBlank(str) || Common.isBlank(toTrim)) {
            return str;
        }
        return Common.trim(str, toTrim.toCharArray());
    }

    @Deprecated
    public static boolean sameString(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static char randomGB2312Char() {
        try {
            int b1 = Common.randomC(176, 215);
            int b2 = Common.randomC(161, b1 == 215 ? 249 : 254);
            return new String(new byte[]{(byte)b1, (byte)b2}, "GB2312").charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static char randomChar(String s) {
        if (Common.isBlank(s)) {
            throw new IllegalArgumentException("range is blank.");
        }
        return s.charAt(Common.random(s.length()));
    }

    public static <T> T random(T[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static byte random(byte[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static short random(short[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static int random(int[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static long random(long[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static float random(float[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static double random(double[] range) {
        if (range == null || range.length == 0) {
            throw new IllegalArgumentException("range is blank.");
        }
        return range[Common.random(range.length)];
    }

    public static String randomStr(int min, int max, String range) {
        StringBuilder builder = new StringBuilder();
        int j = Common.random(min, max);
        for (int i = 0; i < j; ++i) {
            builder.append(Common.randomChar(range));
        }
        return builder.toString();
    }

    public static Calendar copy(Calendar calendar) {
        return calendar == null ? null : (Calendar)calendar.clone();
    }

    public static String lowerFirstChar(String string) {
        if (string == null) {
            return null;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 0 && charSeq[0] >= 'A' && charSeq[0] <= 'Z') {
            charSeq[0] = (char)(charSeq[0] + 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String upperFirstChar(String string) {
        if (string == null) {
            return null;
        }
        char[] charSeq = string.toCharArray();
        if (charSeq.length > 0 && charSeq[0] >= 'a' && charSeq[0] <= 'z') {
            charSeq[0] = (char)(charSeq[0] - 32);
            return new String(charSeq);
        }
        return string;
    }

    public static String camelCase(String s) {
        return Common.camelCase(s, false);
    }

    public static String camelCase(String s, String delimiters) {
        return Common.camelCase(s, false, delimiters);
    }

    public static String camelCase(String s, boolean firstCharUpperCase) {
        return Common.camelCase(s, firstCharUpperCase, DEFAULT_DELIM);
    }

    public static String camelCase(String s, boolean firstCharUpperCase, String delimiters) {
        StringTokenizer st = new StringTokenizer(s, delimiters);
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreElements()) {
            String node = st.nextToken();
            if (node.length() == 0) continue;
            builder.append(Common.upperFirstChar(node));
        }
        return firstCharUpperCase ? Common.upperFirstChar(builder.toString()) : Common.lowerFirstChar(builder.toString());
    }

    private static int calculateStringDistance(String strA, String strB) {
        int i;
        int lenA = strA.length();
        int lenB = strB.length();
        int[][] c = new int[lenA + 1][lenB + 1];
        for (i = 0; i < lenA; ++i) {
            c[i][lenB] = lenA - i;
        }
        for (int j = 0; j < lenB; ++j) {
            c[lenA][j] = lenB - j;
        }
        c[lenA][lenB] = 0;
        for (i = lenA - 1; i >= 0; --i) {
            for (int j = lenB - 1; j >= 0; --j) {
                c[i][j] = strB.charAt(j) == strA.charAt(i) ? c[i + 1][j + 1] : Math.min(Math.min(c[i][j + 1], c[i + 1][j]), c[i + 1][j + 1]) + 1;
            }
        }
        return c[0][0];
    }

    public static double similarity(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0.0;
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        return 1.0 - (double)Common.calculateStringDistance(s1, s2) / ((double)Math.max(s1.length(), s2.length()) * 1.0);
    }

    public static <T> Map<String, T> subMap(String prefix, Map<String, T> map) {
        HashMap<String, T> subMap = new HashMap<String, T>();
        String prefixKey = prefix.endsWith(".") ? prefix : prefix + '.';
        int length = prefixKey.length();
        for (String key : map.keySet()) {
            if (!key.startsWith(prefixKey) || key.length() <= length) continue;
            subMap.put(key.substring(length), map.get(prefixKey));
        }
        return subMap;
    }

    public static String calendarToStr(Calendar calendar, String format) {
        return Common.dateToStr(calendar.getTime(), format);
    }

    public static String calendarToStr(Calendar calendar) {
        return Common.calendarToStr(calendar, DEFAULT_DATETIME_FORMAT);
    }

    public static String dateToStr(Date date, String format) {
        return Common.getSafetyDateFormat(format).format(date);
    }

    public static String dateToStr(Date date) {
        return Common.dateToStr(date, DEFAULT_DATETIME_FORMAT);
    }

    public static DateFormat getSafetyDateFormat(String format) {
        if (threadLocal.get() == null) {
            threadLocal.set(SingletonMap.builder().function(SimpleDateFormat::new).build());
        }
        return threadLocal.get().get(format);
    }

    public static Date strToDate(String str, String format) throws ParseException {
        return Common.getSafetyDateFormat(format).parse(str);
    }

    public static Date strToDate(String str) throws ParseException {
        return Common.strToDate(str, DEFAULT_DATETIME_FORMAT);
    }

    public static Calendar strToCalendar(String str, String format) throws ParseException {
        return Common.dateToCalendar(Common.strToDate(str, format));
    }

    public static byte[] long2Bytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data & 0xFFL)};
    }

    public static String longToDateStr(long l) {
        return Common.longToDateStr(l, DEFAULT_DATETIME_FORMAT);
    }

    public static String longToDateStr(long l, String format) {
        return Common.calendarToStr(Common.longToCalendar(l), format);
    }

    public static Calendar longToCalendar(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar;
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T c1, T c2, T ... others) {
        Objects.requireNonNull(c1, "c1 is null");
        Objects.requireNonNull(c2, "c2 is null");
        T currentMin = Common._min(c1, c2);
        if (others != null && others.length > 0) {
            int len = others.length;
            for (int i = 0; i < len; ++i) {
                Objects.requireNonNull(others[i], "c" + (i + 3) + " is null");
                currentMin = Common._min(currentMin, others[i]);
            }
        }
        return currentMin;
    }

    public static Calendar calendar(int year) {
        return Common.buildCalendar(year, 0, 1, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month) {
        return Common.buildCalendar(year, month, 1, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date) {
        return Common.buildCalendar(year, month, date, 0, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour) {
        return Common.buildCalendar(year, month, date, hour, 0, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute) {
        return Common.buildCalendar(year, month, date, hour, minute, 0, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute, int second) {
        return Common.buildCalendar(year, month, date, hour, minute, second, 0);
    }

    public static Calendar calendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return Common.buildCalendar(year, month, date, hour, minute, second, millisecond);
    }

    private static Calendar buildCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public static Calendar truncate(Calendar calendar, int fromField) {
        Calendar result = (Calendar)calendar.clone();
        switch (fromField) {
            case 1: {
                result.set(1, 1970);
            }
            case 2: {
                result.set(2, 0);
            }
            case 5: {
                result.set(5, 1);
            }
            case 10: 
            case 11: {
                result.set(11, 0);
            }
            case 12: {
                result.set(12, 0);
            }
            case 13: {
                result.set(13, 0);
            }
            case 14: {
                result.set(14, 0);
            }
        }
        return result;
    }

    public static String now() {
        return Common.now(DEFAULT_DATETIME_FORMAT);
    }

    public static String now(String format) {
        return Common.dateToStr(Clock.now().getTime(), format);
    }

    public static RuntimeException rte(Throwable th) {
        return th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th.getLocalizedMessage(), th);
    }

    public static Long getSystemStart() {
        return SYSTEM_START_TIME;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static void sleep(long ms) {
        try {
            Clock.sleep(ms);
        }
        catch (InterruptedException e) {
            throw Common.rte(e);
        }
    }

    public static class StringToBoolean
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toBool(str, (Boolean)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Boolean.TYPE.equals(param) || Boolean.class.equals(param);
        }
    }

    public static class StringToLong
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toLong(str, (Long)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Long.TYPE.equals(param) || Long.class.equals(param);
        }
    }

    public static class StringToInt
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            return Common.toInt(str, (Integer)defaultValue);
        }

        @Override
        public boolean accept(Class<?> param) {
            return Integer.TYPE.equals(param) || Integer.class.equals(param);
        }
    }

    public static class StringToFloat
    implements StringConvertWithDefaultValue {
        @Override
        public Object convertTo(String str, Object defaultValue, Class<?> type) {
            try {
                return Float.valueOf(Float.parseFloat(str));
            }
            catch (Throwable t) {
                return defaultValue;
            }
        }

        @Override
        public boolean accept(Class<?> param) {
            return Float.TYPE.equals(param) || Float.class.equals(param);
        }
    }

    public static enum Edge {
        OPEN_OPEN(0, 0),
        CLOSE_OPEN(-1, 0),
        OPEN_CLOSE(0, 1),
        CLOSE_CLOSE(-1, 1);

        private final int left;
        private final int right;

        private Edge(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public <T extends Comparable<T>> boolean between(T t, T bound1, T bound2) {
            Objects.requireNonNull(t, "t is null");
            Objects.requireNonNull(bound1, "bound1 is null");
            Objects.requireNonNull(bound2, "bound2 is null");
            return t.compareTo((Comparable)Common._min(bound1, bound2)) > this.left && t.compareTo((Comparable)Common._max(bound1, bound2)) < this.right;
        }
    }
}

