/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceScanner {
    private static final ThreadLocal<Integer> EXTRA_PATH_INDEX = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(ResourceScanner.class);
    public static String KEY_RESOURCE_PATH_EXT = "coodex.resource.path";
    private final BiConsumer<URL, String> processor;
    private final Function<String, Boolean> filter;
    private final boolean extraPath;

    private ResourceScanner(BiConsumer<URL, String> processor, Function<String, Boolean> filter, boolean extraPath) {
        this.processor = processor;
        this.filter = filter == null ? s -> true : filter;
        this.extraPath = extraPath;
    }

    public static boolean isExtraPath() {
        return EXTRA_PATH_INDEX.get() != null;
    }

    public static Integer getExtraPathIndex() {
        return EXTRA_PATH_INDEX.get();
    }

    public static List<String> getExtraResourcePath() {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        String param = System.getProperty(KEY_RESOURCE_PATH_EXT, "").trim();
        if (!Common.isBlank(param)) {
            String[] paths;
            for (String path : paths = param.split(Common.PATH_SEPARATOR)) {
                if (Common.isBlank(path)) continue;
                resourcePaths.add(Common.toAbsolutePath(path));
            }
        }
        return resourcePaths;
    }

    public static Builder newBuilder(BiConsumer<URL, String> processor) {
        return new Builder(processor);
    }

    private static Set<PathPattern> toPathPatterns(String[] paths) {
        LinkedHashSet<PathPattern> pathPatterns = new LinkedHashSet<PathPattern>();
        if (paths != null && paths.length > 0) {
            for (String path : paths) {
                pathPatterns.add(new PathPattern(Common.trim(path, new char[0]) + "/"));
            }
        }
        return pathPatterns;
    }

    private static Collection<String> merge(Collection<PathPattern> pathPatterns) {
        ArrayList<String> list = new ArrayList<String>();
        for (PathPattern pathPattern : pathPatterns) {
            list.add(pathPattern.path);
        }
        String[] toMerge = list.toArray(new String[0]);
        list.clear();
        Arrays.sort(toMerge, Comparator.comparingInt(String::length));
        for (String s : toMerge) {
            boolean exits = false;
            for (String x : list) {
                if (!s.startsWith(x)) continue;
                exits = true;
                break;
            }
            if (exits) continue;
            list.add(s);
        }
        return list;
    }

    public void scan(String ... paths) {
        try {
            Set<PathPattern> pathPatterns = ResourceScanner.toPathPatterns(paths);
            Function<String, Boolean> resourceFilter = resourceName -> {
                boolean pathOk = false;
                for (PathPattern pathPattern : pathPatterns) {
                    if (!pathPattern.pattern.matcher((CharSequence)resourceName).matches()) continue;
                    pathOk = true;
                    break;
                }
                return pathOk && this.filter.apply((String)resourceName) != false;
            };
            Collection<String> merged = ResourceScanner.merge(pathPatterns);
            if (this.extraPath) {
                this.scanInExtraPath(resourceFilter, merged);
            }
            for (String path : merged) {
                path = Common.trim(path.replace('\\', '/'), '/');
                Enumeration<URL> resourceRoots = this.getClass().getClassLoader().getResources(path);
                while (resourceRoots.hasMoreElements()) {
                    String zipItemUrl;
                    int lastJarNode;
                    URL url = resourceRoots.nextElement();
                    String urlStr = url.toString();
                    URL baseUrl = new URL(urlStr.substring(0, urlStr.length() - path.length()));
                    log.debug("scan items in {}", (Object)url);
                    if ("file".equalsIgnoreCase(url.getProtocol())) {
                        this.scanInDir(baseUrl, resourceFilter, new File(url.toURI()), path);
                        continue;
                    }
                    String[] nodes = urlStr.split("!/");
                    if (nodes.length == 2) {
                        this.scanInZip(baseUrl, new URL(nodes[0].substring(url.getProtocol().length() + 1)), "", resourceFilter);
                        continue;
                    }
                    String forTest = nodes[nodes.length - 2];
                    forTest = forTest.substring(forTest.length() - 4);
                    String pathInJar = "";
                    if (!".jar".equalsIgnoreCase(forTest) && !".zip".equalsIgnoreCase(forTest)) {
                        pathInJar = nodes[nodes.length - 2] + "/";
                        lastJarNode = nodes.length - 3;
                    } else {
                        lastJarNode = nodes.length - 2;
                    }
                    if (lastJarNode == 0) {
                        zipItemUrl = nodes[0].substring(url.getProtocol().length() + 1);
                    } else {
                        StringJoiner joiner = new StringJoiner("!/");
                        for (int i = 0; i <= lastJarNode; ++i) {
                            joiner.add(nodes[i]);
                        }
                        zipItemUrl = joiner.toString();
                    }
                    this.scanInZip(baseUrl, new URL(zipItemUrl), pathInJar, resourceFilter);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            log.warn("resource search failed. {}.", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }

    private void scanInZip(URL baseUrl, URL zip, String context, Function<String, Boolean> resourceFilter) throws IOException {
        block16: {
            ZipInputStream zipInputStream = new ZipInputStream(zip.openStream());
            Throwable throwable = null;
            block11: while (true) {
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String resourceName;
                        String entryName = zipEntry.getName();
                        if (zipEntry.isDirectory() || !entryName.startsWith(context) || !resourceFilter.apply(resourceName = entryName.substring(context.length())).booleanValue()) continue;
                        try {
                            this.processor.accept(new URL(baseUrl, resourceName), resourceName);
                            continue block11;
                        }
                        catch (Throwable th) {
                            log.warn("resource process failed: {}, {}", new Object[]{baseUrl, resourceName, th});
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (zipInputStream != null) {
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipInputStream.close();
                    }
                }
            }
        }
    }

    private void scanInDir(URL baseURL, Function<String, Boolean> resourceFilter, File searchDir, String contextPath) {
        File[] list = searchDir.listFiles();
        if (list == null || list.length == 0) {
            return;
        }
        for (File f : list) {
            String resourceName;
            if (f.isDirectory()) {
                this.scanInDir(baseURL, resourceFilter, f, contextPath == null ? f.getName() : contextPath + "/" + f.getName());
                continue;
            }
            String string = resourceName = contextPath == null ? f.getName() : contextPath + "/" + f.getName();
            if (!resourceFilter.apply(resourceName).booleanValue()) continue;
            try {
                this.processor.accept(new URL(baseURL, resourceName), resourceName);
            }
            catch (Throwable th) {
                log.warn("resource process failed: {}, {},{}", new Object[]{baseURL, contextPath, resourceName, th});
            }
        }
    }

    private void scanInExtraPath(Function<String, Boolean> resourceFilter, Collection<String> merged) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ResourceScanner.getExtraResourcePath().forEach(root -> {
            EXTRA_PATH_INDEX.set(atomicInteger.getAndIncrement());
            try {
                merged.forEach(path -> {
                    try {
                        path = Common.trim(path.replace('\\', '/'), '/');
                        URL resourceRoot = new File((String)root).toURI().toURL();
                        log.debug("Scan items in coodex.resource.path: [{}]", (Object)resourceRoot.toString());
                        this.scanInDir(resourceRoot, resourceFilter, new File((Common.isBlank(path) ? resourceRoot : new URL(resourceRoot, (String)path)).toURI()), (String)path);
                    }
                    catch (Throwable th) {
                        log.warn("load from {} failed: {}", new Object[]{root, th.getLocalizedMessage(), th});
                    }
                });
            }
            finally {
                EXTRA_PATH_INDEX.remove();
            }
        });
    }

    public static class Builder {
        private final BiConsumer<URL, String> processor;
        private Function<String, Boolean> filter;
        private boolean extraPath = false;

        private Builder(BiConsumer<URL, String> processor) {
            this.processor = Objects.requireNonNull(processor);
        }

        public Builder extraPath(boolean extraPath) {
            this.extraPath = extraPath;
            return this;
        }

        public Builder filter(Function<String, Boolean> filter) {
            this.filter = filter;
            return this;
        }

        public ResourceScanner build() {
            return new ResourceScanner(this.processor, this.filter, this.extraPath);
        }
    }

    private static class PathPattern {
        private final Pattern pattern;
        private final String path;
        private final String originalPath;

        public PathPattern(String path) {
            this.originalPath = path;
            this.pattern = Pattern.compile("^" + Common.trim(path, new char[0]).replaceAll("\\.", "\\\\.").replaceAll("/\\*{2,}/", "(/|/.+/)").replaceAll("\\*{2,}", ".+").replaceAll("\\*", "[^/]+") + ".*");
            this.path = this.pathRoot(path);
        }

        private String pathRoot(String pattern) {
            StringBuilder builder = new StringBuilder();
            StringBuilder node = new StringBuilder();
            for (char ch : pattern.toCharArray()) {
                if (ch == '*') break;
                if (ch == '/') {
                    builder.append((CharSequence)node).append(ch);
                    node = new StringBuilder();
                    continue;
                }
                node.append(ch);
            }
            if (node.length() > 0) {
                builder.append((CharSequence)node);
            }
            return Common.trim(builder.toString(), new char[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathPattern)) {
                return false;
            }
            PathPattern that = (PathPattern)o;
            return this.originalPath.equals(that.originalPath);
        }

        public int hashCode() {
            return this.originalPath.hashCode();
        }
    }
}

