/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.id;

import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.Singleton;

public class SnowflakeIdWorker {
    private static final Singleton<SnowflakeIdWorker> snowflakeIdWorkerSingleton = Singleton.with(() -> new SnowflakeIdWorker(Profile.get("idWorker").getInt("machineId", 0)));
    private final long twepoch = Common.calendar(2020).getTimeInMillis();
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker(int machineId) {
        this(machineId & 0x1F, machineId >> 5);
    }

    public SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public static long getId() {
        return snowflakeIdWorkerSingleton.get().nextId();
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return Clock.currentTimeMillis();
    }
}

