/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.Parameter;
import org.coodex.util.ResourceScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    public static final Function<Class<?>, Boolean> NOT_NULL = Objects::nonNull;
    public static final Function<Class<?>, Boolean> ALL_OBjECT = c -> c != null && c != Object.class;
    public static final Function<Class<?>, Boolean> ALL_OBJECT_EXCEPT_JAVA_SDK = c -> c != null && !c.getName().startsWith("java");
    private static final Logger log = LoggerFactory.getLogger(ReflectHelper.class);

    private ReflectHelper() {
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, AnnotatedElement element, Set<AnnotatedElement> checked) {
        if (checked.contains(element)) {
            return null;
        }
        checked.add(element);
        T t = element.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        for (Annotation annotation : element.getAnnotations()) {
            t = ReflectHelper.getAnnotation(annotationClass, annotation.annotationType(), checked);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, AnnotatedElement ... elements) {
        HashSet<AnnotatedElement> checked = new HashSet<AnnotatedElement>();
        for (AnnotatedElement element : elements) {
            T t = ReflectHelper.getAnnotation(annotationClass, element, checked);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String getParameterName(Object executable, int index, String prefix) {
        if (executable instanceof Method) {
            String parameterName = ReflectHelper.getParameterName((Method)executable, index);
            return parameterName == null ? prefix + index : parameterName;
        }
        if (executable instanceof Constructor) {
            String parameterName = ReflectHelper.getParameterName((Constructor)executable, index);
            return parameterName == null ? prefix + index : parameterName;
        }
        throw new IllegalArgumentException("none Executable object: " + executable);
    }

    private static Method getMethod(Class<?> objClass, String methodName) throws NoSuchMethodException {
        for (Method method : objClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        throw new NoSuchMethodException();
    }

    private static Object invoke(Object obj, String methodName, Object ... args) throws ReflectiveOperationException {
        Field overrideField = AccessibleObject.class.getDeclaredField("override");
        overrideField.setAccessible(true);
        Method targetMethod = ReflectHelper.getMethod(obj.getClass(), methodName);
        overrideField.set(targetMethod, true);
        return targetMethod.invoke(obj, args);
    }

    public static Method getLambdaMethod(Object lambda) throws ReflectiveOperationException {
        Class<?> lambdaClass = lambda.getClass();
        if (!lambdaClass.isSynthetic()) {
            throw new IllegalArgumentException("not lambda instance: " + lambdaClass);
        }
        Object constantPool = ReflectHelper.invoke(lambdaClass, "getConstantPool", new Object[0]);
        for (int i = (Integer)ReflectHelper.invoke(constantPool, "getSize", new Object[0]) - 1; i >= 0; --i) {
            try {
                Object member = ReflectHelper.invoke(constantPool, "getMethodAt", i);
                if (!(member instanceof Method) || !((Method)member).isSynthetic() || ((Method)member).getDeclaringClass() == Object.class) continue;
                return (Method)member;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException();
    }

    public static String getParameterName(Method method, int index) {
        String s = ReflectHelper.getParameterNameByAnnotation(method.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(method, index) : s;
    }

    private static String getParameterNameByAnnotation(Annotation[][] annotations, int index) {
        if (annotations == null || annotations.length < index) {
            return null;
        }
        for (Annotation annotation : annotations[index]) {
            if (!(annotation instanceof Parameter)) continue;
            return ((Parameter)annotation).value();
        }
        return null;
    }

    public static String getParameterName(Constructor executable, int index) {
        String s = ReflectHelper.getParameterNameByAnnotation(executable.getParameterAnnotations(), index);
        return s == null ? ReflectHelper.getParameterNameByJava8(executable, index) : s;
    }

    private static String getParameterNameByJava8(Method executable, int index) {
        try {
            return executable.getParameters()[index].getName();
        }
        catch (Throwable th) {
            return "arg" + index;
        }
    }

    private static String getParameterNameByJava8(Constructor executable, int index) {
        try {
            return executable.getParameters()[index].getName();
        }
        catch (Throwable th) {
            return "arg" + index;
        }
    }

    public static Field[] getAllDeclaredFields(Class<?> clz) {
        return ReflectHelper.getAllDeclaredFields(clz, null);
    }

    public static Field[] getAllDeclaredFields(Class<?> clz, Function<Class<?>, Boolean> decision) {
        if (clz == null) {
            throw new NullPointerException("class is NULL");
        }
        if (decision == null) {
            decision = NOT_NULL;
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<?> clazz = clz;
        while (decision.apply(clazz).booleanValue()) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    public static Object invoke(Object obj, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (obj == null) {
            throw new NullPointerException("invoke target object is NULL.");
        }
        if (method.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            return method.invoke(obj, args);
        }
        return obj.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(obj, args);
    }

    private static String resourceToClassName(String resourceName) {
        if (resourceName.endsWith(".class")) {
            return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        }
        return null;
    }

    private static String[] packageToPath(String[] packages) {
        if (packages == null || packages.length == 0) {
            return new String[0];
        }
        String[] paths = new String[packages.length];
        int i = 0;
        for (String p : packages) {
            paths[i++] = p == null ? "" : p.replace('.', '/');
        }
        return paths;
    }

    public static void foreachClass(Consumer<Class<?>> processor, Function<String, Boolean> filter, String ... packages) {
        if (processor == null) {
            return;
        }
        ResourceScanner.newBuilder((resource, resourceName) -> {
            String className = ReflectHelper.resourceToClassName(resourceName);
            try {
                processor.accept(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.warn("load class fail. {}, {}", (Object)className, (Object)e.getLocalizedMessage());
            }
        }).filter(resourceName -> {
            String className = ReflectHelper.resourceToClassName(resourceName);
            return className != null && (Boolean)filter.apply(className) != false;
        }).build().scan(ReflectHelper.packageToPath(packages));
    }

    public static <T> T throwExceptionObject(Class<T> interfaceClass, Supplier<Throwable> supplier) {
        return Common.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (proxy, method, args) -> {
            throw (Throwable)supplier.get();
        }));
    }

    public static <T> T throwExceptionObject(Class<T> interfaceClass, Function<Method, Throwable> function) {
        return Common.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (proxy, method, args) -> {
            throw (Throwable)function.apply(method);
        }));
    }

    public static String typeToCodeStr(Type type) {
        StringBuilder builder = new StringBuilder();
        if (type instanceof ParameterizedType) {
            builder.append(ReflectHelper.typeToCodeStr(((ParameterizedType)type).getRawType())).append("<");
            int l = ((ParameterizedType)type).getActualTypeArguments().length;
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(ReflectHelper.typeToCodeStr(((ParameterizedType)type).getActualTypeArguments()[i]));
            }
            builder.append(">");
        } else {
            if (type instanceof Class) {
                if (((Class)type).isArray()) {
                    return ReflectHelper.typeToCodeStr(((Class)type).getComponentType()) + "[]";
                }
                return ((Class)type).getName();
            }
            if (type instanceof TypeVariable) {
                return ((TypeVariable)type).getName();
            }
            if (type instanceof GenericArrayType) {
                return ReflectHelper.typeToCodeStr(((GenericArrayType)type).getGenericComponentType()) + "[]";
            }
        }
        return builder.toString();
    }

    private static Object invoke(Method method, Object first, Object[] objects, Object[] args) throws Throwable {
        if (first == null) {
            throw new NullPointerException();
        }
        if (method.getDeclaringClass().isAssignableFrom(first.getClass())) {
            return args == null || args.length == 0 ? method.invoke(first, new Object[0]) : method.invoke(first, args);
        }
        for (Object o : objects) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!method.getDeclaringClass().isAssignableFrom(o.getClass())) continue;
            return args == null || args.length == 0 ? method.invoke(o, new Object[0]) : method.invoke(o, args);
        }
        throw new RuntimeException("method not found in all objects: " + method.getName());
    }

    public static Class<?>[] getAllInterfaces(Class<?> clz) {
        HashSet coll = new HashSet();
        ReflectHelper.addInterfaceTo(clz, coll);
        return coll.toArray(new Class[0]);
    }

    private static void addInterfaceTo(Class<?> clz, Collection<Class<?>> coll) {
        if (clz == null) {
            return;
        }
        if (coll.contains(clz)) {
            return;
        }
        if (clz.isInterface()) {
            coll.add(clz);
        }
        ReflectHelper.addInterfaceTo(clz.getSuperclass(), coll);
        for (Class<?> c : clz.getInterfaces()) {
            ReflectHelper.addInterfaceTo(c, coll);
        }
    }

    public static boolean isAssignable(Class<?> from, Class<?> to) {
        if (from.isArray() && to.isArray()) {
            return Objects.equals(from, to);
        }
        if (from.isArray() || to.isArray()) {
            return false;
        }
        return to.isAssignableFrom(from);
    }

    public static boolean isMatch(Type instanceType, Type serviceType) {
        boolean match = ReflectHelper.isMatchForDebug(instanceType, serviceType);
        if (Common.isDebug() && log.isDebugEnabled()) {
            log.debug("match: {}\ninstance: {}\nservice: {} ", new Object[]{match, instanceType, serviceType});
        }
        return match;
    }

    private static boolean isMatchForDebug(Type instanceType, Type serviceType) {
        if (Objects.equals(instanceType, serviceType)) {
            return true;
        }
        Class<?> instanceClass = GenericTypeHelper.typeToClass(instanceType);
        Class<?> serviceClass = GenericTypeHelper.typeToClass(serviceType);
        if (serviceClass != null && instanceClass != null && !ReflectHelper.isAssignable(instanceClass, serviceClass)) {
            return false;
        }
        if (serviceClass != null && serviceType instanceof ParameterizedType) {
            ParameterizedType parameterizedServiceType = (ParameterizedType)serviceType;
            for (int i = 0; i < parameterizedServiceType.getActualTypeArguments().length; ++i) {
                if (ReflectHelper.isMatch(GenericTypeHelper.solveFromType(serviceClass.getTypeParameters()[i], instanceType), parameterizedServiceType.getActualTypeArguments()[i])) continue;
                return false;
            }
            return true;
        }
        return !(serviceType instanceof GenericArrayType);
    }

    public static <S, T extends S> S extendInterface(T o, Object ... objects) {
        if (o == null) {
            return null;
        }
        if (objects == null || objects.length == 0) {
            return o;
        }
        HashSet interfaces = new HashSet();
        ReflectHelper.addInterfaceTo(o.getClass(), interfaces);
        for (Object x : objects) {
            if (x == null) continue;
            ReflectHelper.addInterfaceTo(x.getClass(), interfaces);
        }
        if (interfaces.size() == 0) {
            return o;
        }
        return (S)Common.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces.toArray(new Class[0]), (proxy, method, args) -> ReflectHelper.invoke(method, o, objects, args)));
    }

    public static class MethodParameter {
        private final Method method;
        private final int index;
        private final String name;
        private final Annotation[] annotations;
        private final Class<?> type;
        private final Type genericType;

        public MethodParameter(Method method, int index) {
            this.method = method;
            this.index = index;
            this.annotations = method.getParameterAnnotations()[index];
            this.type = method.getParameterTypes()[index];
            this.genericType = method.getGenericParameterTypes()[index];
            this.name = ReflectHelper.getParameterName(method, index, "p");
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public <T> T getAnnotation(Class<T> annotationClass) {
            if (annotationClass == null) {
                throw new IllegalArgumentException("annotationClass is NULL.");
            }
            if (this.annotations == null) {
                return null;
            }
            for (Annotation annotation : this.annotations) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                return Common.cast(annotation);
            }
            return null;
        }
    }
}

