/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.coodex.concurrent.Debounce;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonMap<K, V> {
    private static final AtomicLong VERSION = new AtomicLong(Long.MIN_VALUE);
    private static final Singleton<ScheduledExecutorService> DEFAULT_SCHEDULED_EXECUTOR_SERVICE = Singleton.with(() -> ExecutorsHelper.newSingleThreadScheduledExecutor("singletonMap-DEFAULT"));
    private static final Logger log = LoggerFactory.getLogger(SingletonMap.class);
    private final Map<K, Value<V>> map;
    private final Function<K, V> function;
    private final K nullKey;
    private final long maxAge;
    private final BiConsumer<K, V> deathListener;
    private final boolean activeOnGet;
    private final ScheduledExecutorService scheduledExecutorService;
    private long version = VERSION.get();

    private SingletonMap(Function<K, V> function, K nullKey, boolean activeOnGet, long maxAge, BiConsumer<K, V> deathListener, Supplier<Map<K, Value<V>>> mapSupplier, ScheduledExecutorService scheduledExecutorService) {
        this.function = function;
        this.nullKey = nullKey;
        this.maxAge = Math.max(0L, maxAge);
        this.map = mapSupplier == null ? new ConcurrentHashMap() : mapSupplier.get();
        this.deathListener = deathListener;
        this.activeOnGet = activeOnGet;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public static void resetAll() {
        VERSION.incrementAndGet();
    }

    public static <K, V> SingletonMapBuilder<K, V> builder() {
        return new SingletonMapBuilder();
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService == null ? DEFAULT_SCHEDULED_EXECUTOR_SERVICE.get() : this.scheduledExecutorService;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key == null ? this.nullKey : key);
    }

    public V get(K key, Supplier<V> supplier) {
        return this.get(key, supplier, this.maxAge);
    }

    public V get(K key, Supplier<V> supplier, long maxAge) {
        return this.get(key, supplier, maxAge, this.deathListener);
    }

    public V get(K key, Supplier<V> supplier, BiConsumer<K, V> deathListener) {
        return this.get(key, supplier, this.maxAge, deathListener);
    }

    public V get(K key, Supplier<V> supplier, long maxAge, BiConsumer<K, V> deathListener) {
        return (V)this.get(key, (K k) -> Objects.requireNonNull(supplier, "supplier is null").get(), maxAge, deathListener);
    }

    public V get(K key) {
        return this.get(key, this.function);
    }

    public V get(K key, long maxAge) {
        return this.get(key, this.function, maxAge);
    }

    public V get(K key, BiConsumer<K, V> deathListener) {
        return this.get(key, this.function, deathListener);
    }

    public V get(K key, long maxAge, BiConsumer<K, V> deathListener) {
        return this.get(key, this.function, maxAge, deathListener);
    }

    public V get(K key, Function<K, V> function) {
        return this.get(key, function, this.maxAge);
    }

    public V get(K key, Function<K, V> function, long maxAge) {
        return this.get(key, function, maxAge, null);
    }

    public V get(K key, Function<K, V> function, BiConsumer<K, V> deathListener) {
        return this.get(key, function, this.maxAge, deathListener);
    }

    public V get(K key, Function<K, V> function, long maxAge, BiConsumer<K, V> deathListener) {
        return this.getValue(key, () -> function, maxAge, deathListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getValue(K key, Supplier<Function<K, V>> functionSupplier, long maxAge, BiConsumer<K, V> deathListener) {
        K finalKey;
        if (functionSupplier == null) {
            throw new NullPointerException("functionSupplier is null.");
        }
        if (this.version != VERSION.get()) {
            Map<K, Value<V>> map = this.map;
            synchronized (map) {
                if (this.version != VERSION.get()) {
                    this.clear();
                    this.version = VERSION.get();
                }
            }
        }
        K k = finalKey = key == null ? this.nullKey : key;
        if (!this.map.containsKey(finalKey)) {
            Map<K, Value<V>> map = this.map;
            synchronized (map) {
                if (!this.map.containsKey(finalKey)) {
                    V o = Objects.requireNonNull(functionSupplier.get(), "function is null").apply(key);
                    Value value = new Value();
                    value.value = o;
                    if (maxAge > 0L) {
                        value.debounce = Debounce.newBuilder().idle(maxAge).scheduledExecutorService(this.getScheduledExecutorService()).runnable(() -> {
                            Value<V> v = this.map.remove(finalKey);
                            if (v != null) {
                                BiConsumer<K, V> listener;
                                SingletonMap.log.debug("{} die.", finalKey);
                                BiConsumer<K, V> biConsumer = listener = deathListener == null ? this.deathListener : deathListener;
                                if (listener != null) {
                                    try {
                                        listener.accept(finalKey, ((Value)v).value);
                                    }
                                    catch (Throwable th) {
                                        SingletonMap.log.warn("listener process failed: {}", listener, (Object)th);
                                    }
                                }
                            }
                        }).build();
                        value.debounce.submit();
                    }
                    this.map.put(finalKey, value);
                }
            }
        }
        Value<V> value = this.map.get(finalKey);
        if (this.activeOnGet && ((Value)value).debounce != null) {
            ((Value)value).debounce.submit();
            log.debug("{} active.", finalKey);
        }
        return (V)((Value)value).value;
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet().stream().map(entry -> new Map.Entry<K, V>((Map.Entry)entry){
            final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
            }

            @Override
            public K getKey() {
                return this.val$entry.getKey();
            }

            @Override
            public V getValue() {
                return ((Value)this.val$entry.getValue()).value;
            }

            @Override
            public V setValue(V value) {
                return null;
            }
        }).collect(Collectors.toSet());
    }

    public <C extends Collection<V>> C fill(C collection, Collection<K> keys) {
        if (collection == null) {
            throw new NullPointerException("collection is null.");
        }
        if (keys != null && keys.size() > 0) {
            for (Object key : new LinkedHashSet<K>(keys)) {
                collection.add(this.get(key));
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        K finalKey;
        K k = finalKey = key == null ? this.nullKey : key;
        if (this.map.containsKey(finalKey)) {
            Map<K, Value<V>> map = this.map;
            synchronized (map) {
                if (this.map.containsKey(finalKey)) {
                    Value<V> value = this.map.remove(finalKey);
                    if (value != null) {
                        if (((Value)value).debounce != null) {
                            ((Value)value).debounce.cancel();
                        }
                        return (V)((Value)value).value;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public Collection<V> values() {
        return this.map.values().stream().map(value -> ((Value)value).value).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, Value<V>> map = this.map;
        synchronized (map) {
            if (this.map.size() > 0) {
                this.map.forEach((key, v) -> {
                    if (v != null && ((Value)v).debounce != null) {
                        ((Value)v).debounce.cancel();
                    }
                });
                this.map.clear();
            }
        }
    }

    public void reset() {
        this.clear();
    }

    public static class SingletonMapBuilder<K, V> {
        private Function<K, V> function;
        private K nullKey;
        private boolean activeOnGet;
        private long maxAge;
        private BiConsumer<K, V> deathListener;
        private Supplier<Map<K, Value<V>>> mapSupplier;
        private ScheduledExecutorService scheduledExecutorService;

        SingletonMapBuilder() {
        }

        public SingletonMapBuilder<K, V> function(Function<K, V> function) {
            this.function = function;
            return this;
        }

        public SingletonMapBuilder<K, V> nullKey(K nullKey) {
            this.nullKey = nullKey;
            return this;
        }

        public SingletonMapBuilder<K, V> activeOnGet(boolean activeOnGet) {
            this.activeOnGet = activeOnGet;
            return this;
        }

        public SingletonMapBuilder<K, V> maxAge(long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public SingletonMapBuilder<K, V> deathListener(BiConsumer<K, V> deathListener) {
            this.deathListener = deathListener;
            return this;
        }

        public SingletonMapBuilder<K, V> mapSupplier(Supplier<Map<K, Value<V>>> mapSupplier) {
            this.mapSupplier = mapSupplier;
            return this;
        }

        public SingletonMapBuilder<K, V> scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public SingletonMap<K, V> build() {
            return new SingletonMap(this.function, this.nullKey, this.activeOnGet, this.maxAge, this.deathListener, this.mapSupplier, this.scheduledExecutorService);
        }
    }

    public static class Value<V> {
        private Debounce debounce;
        private V value;
    }
}

