/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.clock;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.coodex.util.clock.DefaultClockAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockAgentService
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ClockAgentService.class);
    public static int PORT = 8360;
    private final int port;
    private final String host;
    private final DefaultClockAgent defaultClockAgent = new DefaultClockAgent();
    private boolean listening = false;

    public ClockAgentService() {
        this("0.0.0.0", PORT);
    }

    public ClockAgentService(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try (ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();){
                serverSocketChannel.configureBlocking(false);
                serverSocketChannel.socket().bind(new InetSocketAddress(this.host, this.port));
                log.info("Clock Agent Service start [{}:{}]....", (Object)this.host, (Object)this.port);
                this.listening = true;
                Selector selector = Selector.open();
                serverSocketChannel.register(selector, 16);
                while (this.listening) {
                    if (selector.select(3000L) == 0) continue;
                    Iterator<SelectionKey> keyIterator = selector.selectedKeys().iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        if (key.isAcceptable()) {
                            SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
                            socketChannel.configureBlocking(false);
                            ByteBuffer buffer = ByteBuffer.allocate(20);
                            buffer.putLong(0, this.defaultClockAgent.getStart());
                            buffer.putLong(8, this.defaultClockAgent.getBaseLine());
                            buffer.putFloat(16, this.defaultClockAgent.getMagnification().floatValue());
                            socketChannel.write(buffer);
                        }
                        keyIterator.remove();
                    }
                }
            }
            finally {
                log.debug("Clock Agent Service shutdown.");
            }
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        this.listening = false;
    }
}

