/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import org.coodex.util.CRC;
import org.coodex.util.Common;
import org.coodex.util.Endianness;

public abstract class AbstractBytesBuilder<T extends AbstractBytesBuilder> {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final Endianness endianness;
    private final Charset charset;

    public AbstractBytesBuilder(Endianness endianness, Charset charset) {
        this.endianness = endianness;
        this.charset = charset;
    }

    protected T appendInt64(long l, int wide) {
        return this.append(Common.toBytes(l, wide, this.endianness));
    }

    public T appendByte(byte b) {
        return this.appendByte(b & 0xFF);
    }

    public T appendByte(int b) {
        this.byteArrayOutputStream.write(b);
        return this.getThis();
    }

    public T append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public T append(byte[] buf, int off, int len) {
        this.byteArrayOutputStream.write(buf, off, len);
        return this.getThis();
    }

    public T appendShort(short word) {
        return this.appendShort(word & 0xFFFF);
    }

    public T appendShort(int word) {
        return this.appendInt64((long)word & 0xFFFFFFFFL, 2);
    }

    public T appendInt(int i) {
        return this.appendInt64((long)i & 0xFFFFFFFFL, 4);
    }

    public T appendLong(long l) {
        return this.appendInt64(l, 8);
    }

    public T appendFloat(float f) {
        return this.appendInt(Float.floatToIntBits(f));
    }

    public T appendDouble(double d) {
        return this.appendLong(Double.doubleToLongBits(d));
    }

    public T appendString(String s) {
        return this.appendString(s, this.charset);
    }

    public T appendString(String s, String charsetName) {
        return this.appendString(s, Charset.forName(charsetName));
    }

    public T appendString(String s, Charset charset) {
        return this.append(s.getBytes(charset));
    }

    public T appendCRC(CRC.Algorithm algorithm) {
        return this.appendCRC(algorithm, this.endianness);
    }

    public T appendCRC(CRC.Algorithm algorithm, int off, int len) {
        return this.appendCRC(algorithm, off, len, this.endianness);
    }

    public T appendCRC(CRC.Algorithm algorithm, Endianness endianness) {
        return this.appendCRC(algorithm, 0, this.byteArrayOutputStream.size(), endianness);
    }

    public T appendCRC(CRC.Algorithm algorithm, int off, int len, Endianness endianness) {
        return this.append(Common.toBytes(CRC.calculateCRC(algorithm, this.byteArrayOutputStream.toByteArray(), off, len), algorithm.getParameters().getWidth() / 8, endianness));
    }

    protected abstract T getThis();

    public byte[] toByteArray() {
        return this.byteArrayOutputStream.toByteArray();
    }
}

