/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.concurrent.FrequencyReducer;
import org.coodex.util.Clock;

public class Throttle
implements FrequencyReducer {
    private ScheduledFuture<?> prevFuture;
    private volatile long prevTimestamp;
    private final ReentrantLock lock = new ReentrantLock();
    private final long interval;
    private final boolean asyncAlways;
    private final Runnable runnable;
    private final ScheduledExecutorService scheduledExecutorService;

    @Override
    public void submit() {
        this.submit(this.runnable);
    }

    private long next() {
        long n = Clock.currentTimeMillis() - this.prevTimestamp;
        return n > this.interval ? 0L : Math.max(n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable instance is null.");
        }
        this.lock.lock();
        try {
            if (this.prevFuture != null) {
                this.prevFuture.cancel(false);
            }
            Runnable body = () -> {
                this.lock.lock();
                try {
                    this.prevTimestamp = Clock.currentTimeMillis();
                    runnable.run();
                }
                finally {
                    this.prevFuture = null;
                    this.lock.unlock();
                }
            };
            long n = this.next();
            if (n == 0L) {
                if (this.asyncAlways) {
                    this.scheduledExecutorService.execute(body);
                } else {
                    body.run();
                }
            } else {
                this.prevFuture = this.scheduledExecutorService.schedule(body, this.interval - n, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private Throttle(Builder builder) {
        this.interval = Math.max(0L, builder.interval);
        this.asyncAlways = builder.asyncAlways;
        this.runnable = builder.runnable;
        this.scheduledExecutorService = builder.scheduledExecutorService == null ? (ScheduledExecutorService)DEFAULT_REDUCER_EXECUTOR_SERVICE_SINGLETON.get() : builder.scheduledExecutorService;
    }

    public static class Builder {
        private long interval = 100L;
        private boolean asyncAlways = false;
        private ScheduledExecutorService scheduledExecutorService;
        private Runnable runnable;

        private Builder() {
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder asyncAlways(boolean asyncAlways) {
            this.asyncAlways = asyncAlways;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder runnable(Runnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Throttle build() {
            return new Throttle(this);
        }
    }
}

