/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util.clock;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.coodex.util.Common;
import org.coodex.util.clock.ClockAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClockAgent
implements ClockAgent {
    private static final Logger log = LoggerFactory.getLogger(AbstractClockAgent.class);
    private final Float magnification;
    private final long baseLine;
    private final long start;

    public AbstractClockAgent(Float magnification, long baseLine, long start) {
        this.magnification = magnification;
        this.baseLine = baseLine;
        this.start = start;
        if (log.isDebugEnabled()) {
            log.debug("ClockAgent[{}]: \n\tmagnification: {}\n\tbaseLine: {}\n\tstart at: {}", new Object[]{this.getClass().getName(), this.magnification, Common.calendarToStr(Common.longToCalendar(this.baseLine), "yyyy-MM-dd HH:mm:ss.SSS"), Common.calendarToStr(Common.longToCalendar(this.start), "yyyy-MM-dd HH:mm:ss.SSS")});
        }
    }

    public Float getMagnification() {
        return this.magnification;
    }

    public long getBaseLine() {
        return this.baseLine;
    }

    public long getStart() {
        return this.start;
    }

    private long diff() {
        return (long)((float)(System.currentTimeMillis() - this.start) * this.magnification.floatValue());
    }

    @Override
    public long currentTimeMillis() {
        return this.baseLine + this.diff();
    }

    @Override
    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.currentTimeMillis());
        return calendar;
    }

    @Override
    public void sleep(long millis) throws InterruptedException {
        if (millis <= 0L) {
            return;
        }
        Thread.sleep((long)Math.max((float)millis / this.magnification.floatValue(), 1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objWait(Object obj, long millis) throws InterruptedException {
        if (millis <= 0L) {
            return;
        }
        Object object = obj;
        synchronized (object) {
            obj.wait((long)Math.max((float)millis / this.magnification.floatValue(), 1.0f));
        }
    }

    @Override
    public long toMillis(long duration, TimeUnit timeUnit) {
        return (long)((float)timeUnit.toMillis(duration) / this.magnification.floatValue());
    }

    @Override
    public void sleep(TimeUnit unit, long timeout) throws InterruptedException {
        this.sleep(unit.toMillis(timeout));
    }
}

