/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.spring;

import java.util.Optional;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.Order;

@Named
@Order(value=-2147483648)
public class SpringBeanFactoryAware
implements SmartInstantiationAwareBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanFactoryAware.class);
    private static ListableBeanFactory listableBeanFactory;

    public SpringBeanFactoryAware(ListableBeanFactory beanFactory) {
        listableBeanFactory = beanFactory;
        log.info("coodex-spring: listable bean factory injected. {}", Optional.ofNullable(beanFactory).map(Object::getClass).orElse(null));
    }

    public static ListableBeanFactory getListableBeanFactory() {
        if (listableBeanFactory == null && log.isDebugEnabled()) {
            StackTraceElement[] stackTraceElements;
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : stackTraceElements = new Exception().getStackTrace()) {
                builder.append("\n\tat ").append(element);
            }
            log.debug("spring bean factory not injected yet.{}", (Object)builder);
        }
        return listableBeanFactory;
    }
}

