/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.spring;

import java.util.Optional;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Named
@Order(value=-2147483648)
public class SpringEnvironmentAware
implements SmartInstantiationAwareBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringEnvironmentAware.class);
    private static Environment springEnvironment;

    public SpringEnvironmentAware(Environment environment) {
        springEnvironment = environment;
        log.info("coodex-spring: spring environment injected. {}", Optional.ofNullable(environment).map(Object::getClass).orElse(null));
    }

    public static Environment getSpringEnvironment() {
        if (springEnvironment == null && log.isDebugEnabled()) {
            StackTraceElement[] stackTraceElements;
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : stackTraceElements = new Exception().getStackTrace()) {
                builder.append("\n\tat ").append(element);
            }
            log.debug("spring environment not injected yet.{}", (Object)builder);
        }
        return springEnvironment;
    }
}

