/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.coodex.util.AbstractServiceLoaderProvider;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtilServiceLoaderProvider
extends AbstractServiceLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JavaUtilServiceLoaderProvider.class);
    private static final boolean SINGLETON_ENABLED = Common.toBool(System.getProperty(ServiceLoader.class.getName() + ".singleton.enable"), true);
    private static final boolean CACHE_ENABLED = Common.toBool(System.getProperty(ServiceLoader.class.getName() + ".cache.enable"), true);
    private static final SingletonMap<Class<?>, Map<String, Object>> cache = SingletonMap.builder().build();

    @Override
    protected Map<String, Object> loadByRowType(Class<?> rowType) {
        Map objectMap;
        Supplier<Map> supplier = () -> {
            Class<?>[] interfaces = rowType.getInterfaces();
            if (interfaces.length == 0) {
                return this.loadByInterface(rowType);
            }
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            HashSet classes = new HashSet();
            BiConsumer<String, Object> biConsumer = (key, value) -> {
                Class<?> instanceClass = value.getClass();
                if (!classes.contains(instanceClass) && ReflectHelper.isMatch(instanceClass, rowType)) {
                    classes.add(instanceClass);
                    objectMap.put((String)key, value);
                }
            };
            for (Class<?> interfaceClass : interfaces) {
                if (SINGLETON_ENABLED) {
                    this.loadByRowType(interfaceClass).forEach(biConsumer);
                    continue;
                }
                objectMap.putAll(this.loadByRowType(interfaceClass));
            }
            if (rowType.isInterface()) {
                this.loadByInterface(rowType).forEach(biConsumer);
            }
            return objectMap;
        };
        Map map = objectMap = CACHE_ENABLED ? cache.get(rowType, supplier) : supplier.get();
        if (Common.isDebug() && log.isDebugEnabled()) {
            if (objectMap.size() > 0) {
                StringJoiner joiner = new StringJoiner("\n\t");
                objectMap.forEach((k, v) -> joiner.add(k + ": " + v.toString()));
                log.debug("{} JUS instances loaded for: {} instances: \n\t{}", new Object[]{objectMap.size(), rowType, joiner.toString()});
            } else {
                log.debug("no JUS instance loaded for {}", rowType);
            }
        }
        return objectMap;
    }

    private Map<String, Object> loadByInterface(Class<?> interfaceClass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object service : ServiceLoader.load(interfaceClass)) {
            map.put(service.getClass().getName(), service);
        }
        return map;
    }
}

