/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.coodex.config.Config;
import org.coodex.util.ActiveProfilesProvider;
import org.coodex.util.Common;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.MergedProfile;
import org.coodex.util.ProfileProvider;
import org.coodex.util.ProfileWrapper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.Singleton;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Profile {
    static final Profile NULL_PROFILE = new NullProfile();
    private static final Logger log = LoggerFactory.getLogger(Profile.class);
    private static final LazySelectableServiceLoader<URL, ProfileProvider> PROFILE_PROVIDER_LOADER = new LazySelectableServiceLoader<URL, ProfileProvider>(){};
    private static final Singleton<String[]> ALL_SUPPORTED_FILE_EXT = Singleton.with(() -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ProfileProvider profileProvider : PROFILE_PROVIDER_LOADER.sorted()) {
            if (!profileProvider.isAvailable()) continue;
            list.addAll(Arrays.asList(profileProvider.getSupported()));
        }
        return list.toArray(new String[0]);
    });
    private static final URL DEFAULT_URL;
    private static final SingletonMap<String, Profile> WRAPPER_PROFILES;
    private static final Singleton<Long> RELOAD_INTERVAL_SINGLETON;
    private static final SingletonMap<String, URL> PROFILE_URLS;
    private static final SingletonMap<URL, Profile> URL_PROFILES_MAP;
    private static final ServiceLoader<ActiveProfilesProvider> ACTIVE_PROFILES_PROVIDER_SERVICE_LOADER;
    static final SingletonMap<String, Profile> PATH_PROFILE_MAP;

    public static String[] allSupportedFileExt() {
        return ALL_SUPPORTED_FILE_EXT.get();
    }

    public static Profile get(URL url) {
        return URL_PROFILES_MAP.get(url);
    }

    private static List<URL> getExistsUrl(List<URL> activeProfile, URL baseUrl) {
        if (DEFAULT_URL.equals(baseUrl)) {
            return activeProfile;
        }
        ArrayList<URL> list = new ArrayList<URL>(activeProfile);
        list.add(baseUrl);
        return list;
    }

    private static List<String> getActiveProfiles() {
        ArrayList activeProfiles = new ArrayList();
        ACTIVE_PROFILES_PROVIDER_SERVICE_LOADER.sorted().forEach(activeProfilesProvider -> {
            for (String s : activeProfilesProvider.getActiveProfiles()) {
                if (activeProfiles.contains(s)) continue;
                activeProfiles.add(s);
            }
        });
        return Collections.unmodifiableList(activeProfiles);
    }

    private static Profile getByPath(String path) {
        List<URL> activeProfileUrls = Profile.getActiveProfiles().stream().map(ap -> PROFILE_URLS.get(path + "-" + ap)).filter(url -> !DEFAULT_URL.equals(url)).collect(Collectors.toList());
        URL baseProfileUrl = PROFILE_URLS.get(path);
        List<URL> exists = Profile.getExistsUrl(activeProfileUrls, baseProfileUrl);
        switch (exists.size()) {
            case 0: {
                return Profile.get(DEFAULT_URL);
            }
            case 1: {
                return Profile.get(exists.get(0));
            }
        }
        MergedProfile mergedProfile = new MergedProfile();
        exists.forEach(url -> mergedProfile.merge(Profile.get(url)));
        return mergedProfile;
    }

    public static Profile get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        return WRAPPER_PROFILES.get(path);
    }

    public static Profile get(String path1, String path2, String ... others) {
        MergedProfile mergedProfile = new MergedProfile().merge(Profile.get(path1)).merge(Profile.get(path2));
        if (others != null && others.length > 0) {
            for (String path : others) {
                mergedProfile.merge(Profile.get(path));
            }
        }
        return mergedProfile;
    }

    public boolean getBool(String key, boolean v) {
        return Common.toBool(this.getString(key), v);
    }

    public boolean getBool(String key) {
        return this.getBool(key, false);
    }

    protected abstract String getStringImpl(String var1);

    protected abstract boolean isNull(String var1);

    private boolean isPlaceHolder(String v) {
        return v.startsWith("${") && v.endsWith("}");
    }

    private String actualValue(String v) {
        if (this.isPlaceHolder(v)) {
            String x = v.substring(2, v.length() - 1);
            int index = x.indexOf(58);
            String namespace = null;
            String key = x;
            if (index > 0) {
                namespace = x.substring(0, index);
                key = x.substring(index + 1);
            }
            Profile profile = namespace == null ? this : Profile.get(namespace);
            return profile.getString(key);
        }
        return v;
    }

    public String getString(String key, Supplier<String> supplier) {
        String s = this.getStringImpl(key);
        return s == null ? supplier.get() : this.actualValue(s);
    }

    public String getString(String key, String v) {
        String s = this.getStringImpl(key);
        return s == null ? v : this.actualValue(s);
    }

    public String getString(String key) {
        return this.getString(key, (String)null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, Supplier<Integer> v) {
        return Common.toInt(this.getString(key), v);
    }

    public int getInt(String key, int v) {
        return Common.toInt(this.getString(key), v);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long v) {
        return Common.toLong(this.getString(key), v);
    }

    public long getLong(String key, Supplier<Long> v) {
        return Common.toLong(this.getString(key), v);
    }

    public String[] getStrList(String key) {
        return this.getStrList(key, ",");
    }

    public String[] getStrList(String key, String delim) {
        return this.getStrList(key, delim, (String[])null);
    }

    public String[] getStrList(String key, String delim, Supplier<String[]> supplier) {
        return Common.toArray(this.getString(key), delim, supplier);
    }

    public String[] getStrList(String key, Supplier<String[]> supplier) {
        return Common.toArray(this.getString(key), ",", supplier);
    }

    public String[] getStrList(String key, String delim, String[] v) {
        return Common.toArray(this.getString(key), delim, v);
    }

    static {
        WRAPPER_PROFILES = SingletonMap.builder().function(ProfileWrapper::new).build();
        RELOAD_INTERVAL_SINGLETON = Singleton.with(() -> (Long)((Object)Config.BASE_SYSTEM_PROPERTIES.getValue(Profile.class.getName() + ".reloadInterval", () -> Common.toLong(System.getProperty("Profile.reloadInterval"), 0L), new String[0])) * 1000L);
        PROFILE_URLS = SingletonMap.builder().function(new Function<String, URL>(){

            @Override
            public URL apply(String key) {
                String[] ex;
                for (String s : ex = Profile.allSupportedFileExt()) {
                    URL x;
                    if (key.endsWith(s) && (x = Common.getResource(key, new ClassLoader[0])) != null) {
                        return x;
                    }
                    x = Common.getResource(key + s, new ClassLoader[0]);
                    if (x == null) continue;
                    return x;
                }
                if (log.isInfoEnabled()) {
                    StringBuilder builder = new StringBuilder("Profile ").append(key).append(" not found.[");
                    for (int i = 0; i < ex.length; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        builder.append("'").append(ex[i]).append("'");
                    }
                    builder.append("]");
                    log.info(builder.toString());
                }
                return DEFAULT_URL;
            }
        }).maxAge(RELOAD_INTERVAL_SINGLETON.get()).build();
        URL_PROFILES_MAP = SingletonMap.builder().function(new Function<URL, Profile>(){

            @Override
            public Profile apply(URL key) {
                if (key == null) {
                    throw new NullPointerException("profile url could not be null.");
                }
                if (DEFAULT_URL.equals(key)) {
                    return NULL_PROFILE;
                }
                ProfileProvider profileProvider = (ProfileProvider)PROFILE_PROVIDER_LOADER.select(key);
                if (profileProvider == null) {
                    return NULL_PROFILE;
                }
                return profileProvider.get(key);
            }
        }).maxAge(RELOAD_INTERVAL_SINGLETON.get()).build();
        ACTIVE_PROFILES_PROVIDER_SERVICE_LOADER = new LazyServiceLoader<ActiveProfilesProvider>(){};
        PATH_PROFILE_MAP = SingletonMap.builder().function(Profile::getByPath).maxAge(RELOAD_INTERVAL_SINGLETON.get()).build();
        try {
            DEFAULT_URL = new URL("file:/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private static class NullProfile
    extends Profile {
        private NullProfile() {
        }

        @Override
        protected String getStringImpl(String key) {
            return null;
        }

        @Override
        protected boolean isNull(String key) {
            return true;
        }
    }
}

