/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.coodex.config.AbstractConfiguration;
import org.coodex.config.Configuration;
import org.coodex.config.ConfigurationBaseProfile;
import org.coodex.config.DefaultConfigurationProvider;
import org.coodex.util.Common;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final SystemPropertiesConfiguration BASE_SYSTEM_PROPERTIES = new SystemPropertiesConfiguration();
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Singleton<WrappedConfiguration> WRAPPED_CONFIGURATION = Singleton.with(() -> new WrappedConfiguration(new LazyServiceLoader<Configuration>(() -> ((DefaultConfigurationProvider)new LazyServiceLoader<DefaultConfigurationProvider>(ConfigurationBaseProfile::new){}.get()).get()){}));

    public static Configuration getConfig() {
        return WRAPPED_CONFIGURATION.get();
    }

    public static String get(String key, String ... namespaces) {
        return Config.getConfig().get(key, namespaces);
    }

    public static <T> T getValue(String key, T defaultValue, String ... namespace) {
        return Config.getConfig().getValue(key, defaultValue, namespace);
    }

    public static <T> T getValue(String key, Supplier<T> defaultValueSupplier, String ... namespace) {
        return Config.getConfig().getValue(key, defaultValueSupplier, namespace);
    }

    public static String[] getArray(String key, String ... namespaces) {
        return Config.getArray(key, () -> null, namespaces);
    }

    public static String[] getArray(String key, String[] defaultValue, String ... namespaces) {
        return Config.getArray(key, () -> defaultValue, namespaces);
    }

    public static String[] getArray(String key, Supplier<String[]> supplier, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), ",", supplier);
    }

    @Deprecated
    public static String[] getArray(String key, String delim, String[] defaultValue, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), delim, defaultValue);
    }

    @Deprecated
    public static String[] getArray(String key, String delim, Supplier<String[]> supplier, String ... namespaces) {
        return Common.toArray(Config.get(key, namespaces), delim, supplier);
    }

    private static class WrappedConfiguration
    extends AbstractConfiguration {
        private final Singleton<List<Configuration>> configuration = Singleton.with(() -> {
            ArrayList configurationList = new ArrayList(configurationServiceLoader.sorted());
            Configuration defaultConfiguration = (Configuration)configurationServiceLoader.getDefault();
            if (defaultConfiguration != null) {
                configurationList.add(configurationServiceLoader.getDefault());
            }
            configurationList.add(BASE_SYSTEM_PROPERTIES);
            return configurationList;
        });

        private WrappedConfiguration(ServiceLoader<Configuration> configurationServiceLoader) {
        }

        @Override
        protected String search(String namespace, List<String> keys) {
            for (Configuration c : this.configuration.get()) {
                for (String key : keys) {
                    String v = c.get(key, namespace);
                    if (v == null) continue;
                    if (Common.isDebug() && log.isDebugEnabled()) {
                        if (namespace == null) {
                            log.debug("load config: {}={} by {}", new Object[]{key, v, c.getClass()});
                        } else {
                            log.debug("load config: {}.{}={}; by {}", new Object[]{namespace, key, v, c.getClass()});
                        }
                    }
                    return v;
                }
            }
            return null;
        }
    }

    public static class SystemPropertiesConfiguration
    extends AbstractConfiguration {
        @Override
        protected String search(String namespace, List<String> keys) {
            Properties properties = System.getProperties();
            for (String key : keys) {
                if (!properties.containsKey(key)) continue;
                return System.getProperty(key);
            }
            return null;
        }
    }
}

