/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

public class CRC {
    private final Parameters crcParams;
    private final long initValue;
    private final long[] crcTable;
    private final long mask;
    private long curValue;

    public CRC(Algorithm algorithm) {
        this(algorithm.parameters);
    }

    public CRC(Parameters crcParams) {
        this.crcParams = new Parameters(crcParams);
        this.initValue = crcParams.reflectIn ? CRC.reflect(crcParams.init, crcParams.width) : crcParams.init;
        this.mask = (crcParams.width >= 64 ? 0L : 1L << crcParams.width) - 1L;
        this.crcTable = new long[256];
        byte[] tmp = new byte[1];
        Parameters tableParams = new Parameters(crcParams);
        tableParams.init = 0L;
        tableParams.reflectOut = tableParams.reflectIn;
        tableParams.finalXor = 0L;
        for (int i = 0; i < 256; ++i) {
            tmp[0] = (byte)i;
            this.crcTable[i] = CRC.calculateCRC(crcParams, tmp);
        }
        this.curValue = this.initValue;
    }

    private static long reflect(long in, int count) {
        long ret = in;
        for (int idx = 0; idx < count; ++idx) {
            long srcbit = 1L << idx;
            long dstbit = 1L << count - idx - 1;
            if ((in & srcbit) != 0L) {
                ret |= dstbit;
                continue;
            }
            ret &= dstbit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    public static long calculateCRC(Algorithm algorithm, byte[] data) {
        return CRC.calculateCRC(algorithm, data, 0, data.length);
    }

    public static long calculateCRC(Algorithm algorithm, byte[] data, int offset, int length) {
        return CRC.calculateCRC(algorithm.parameters, data, offset, length);
    }

    public static long calculateCRC(Parameters crcParams, byte[] data) {
        return CRC.calculateCRC(crcParams, data, 0, data.length);
    }

    public static long calculateCRC(Parameters crcParams, byte[] data, int offset, int length) {
        long curValue = crcParams.init;
        long topBit = 1L << crcParams.width - 1;
        long mask = (topBit << 1) - 1L;
        int upper = Math.min(offset + length, data.length);
        for (int i = offset; i < upper; ++i) {
            long curByte = (long)data[i] & 0xFFL;
            if (crcParams.reflectIn) {
                curByte = CRC.reflect(curByte, 8);
            }
            for (int j = 128; j != 0; j >>= 1) {
                long bit = curValue & topBit;
                curValue <<= 1;
                if ((curByte & (long)j) != 0L) {
                    bit ^= topBit;
                }
                if (bit == 0L) continue;
                curValue ^= crcParams.polynomial;
            }
        }
        if (crcParams.reflectOut) {
            curValue = CRC.reflect(curValue, crcParams.width);
        }
        return (curValue ^= crcParams.finalXor) & mask;
    }

    public long init() {
        return this.initValue;
    }

    public long update(byte[] chunk, int offset, int length) {
        if (this.crcParams.reflectIn) {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                this.curValue = this.crcTable[((byte)this.curValue ^ v) & 0xFF] ^ this.curValue >>> 8;
            }
        } else if (this.crcParams.width < 8) {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                this.curValue = this.crcTable[((byte)(this.curValue << 8 - this.crcParams.width) ^ v) & 0xFF] ^ this.curValue << 8;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                this.curValue = this.crcTable[((byte)(this.curValue >>> this.crcParams.width - 8) ^ v) & 0xFF] ^ this.curValue << 8;
            }
        }
        return this.curValue;
    }

    public long update(byte[] chunk) {
        return this.update(chunk, 0, chunk.length);
    }

    public long finalCRC() {
        if (this.crcParams.reflectOut != this.crcParams.reflectIn) {
            this.curValue = CRC.reflect(this.curValue, this.crcParams.width);
        }
        this.curValue = (this.curValue ^ this.crcParams.finalXor) & this.mask;
        return this.curValue;
    }

    public byte finalCRC8() {
        if (this.crcParams.width != 8) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (byte)this.finalCRC();
    }

    public short finalCRC16() {
        if (this.crcParams.width != 16) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (short)this.finalCRC();
    }

    public int finalCRC32() {
        if (this.crcParams.width != 32) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (int)this.finalCRC();
    }

    public static class Parameters {
        private final int width;
        private final long polynomial;
        private final boolean reflectIn;
        private boolean reflectOut;
        private long init;
        private long finalXor;

        public Parameters(int width, long polynomial, long init, boolean reflectIn, boolean reflectOut, long finalXor) {
            this.width = width;
            this.polynomial = polynomial;
            this.reflectIn = reflectIn;
            this.reflectOut = reflectOut;
            this.init = init;
            this.finalXor = finalXor;
        }

        Parameters(Parameters orig) {
            this.width = orig.width;
            this.polynomial = orig.polynomial;
            this.reflectIn = orig.reflectIn;
            this.reflectOut = orig.reflectOut;
            this.init = orig.init;
            this.finalXor = orig.finalXor;
        }

        public int getWidth() {
            return this.width;
        }

        public long getPolynomial() {
            return this.polynomial;
        }

        public boolean isReflectIn() {
            return this.reflectIn;
        }

        public boolean isReflectOut() {
            return this.reflectOut;
        }

        public long getInit() {
            return this.init;
        }

        public long getFinalXor() {
            return this.finalXor;
        }
    }

    public static enum Algorithm {
        CRC8(new Parameters(8, 7L, 0L, false, false, 0L)),
        CRC8_CDMA2000(new Parameters(8, 155L, 255L, false, false, 0L)),
        CRC8_DARC(new Parameters(8, 57L, 0L, true, true, 0L)),
        CRC8_DVB_S2(new Parameters(8, 213L, 0L, false, false, 0L)),
        CRC8_EBU(new Parameters(8, 29L, 255L, true, true, 0L)),
        CRC8_I_CODE(new Parameters(8, 29L, 253L, false, false, 0L)),
        CRC8_ITU(new Parameters(8, 7L, 0L, false, false, 85L)),
        CRC8_MAXIM(new Parameters(8, 49L, 0L, true, true, 0L)),
        CRC8_ROHC(new Parameters(8, 7L, 255L, true, true, 0L)),
        CRC8_WCDMA(new Parameters(8, 155L, 0L, true, true, 0L)),
        CRC16_CCITT_FALSE(new Parameters(16, 4129L, 65535L, false, false, 0L)),
        CRC16_ARC(new Parameters(16, 32773L, 0L, true, true, 0L)),
        CRC16_AUG_CCITT(new Parameters(16, 4129L, 7439L, false, false, 0L)),
        CRC16_BUYPASS(new Parameters(16, 32773L, 0L, false, false, 0L)),
        CRC16_CDMA2000(new Parameters(16, 51303L, 65535L, false, false, 0L)),
        CRC16_DDS110(new Parameters(16, 32773L, 32781L, false, false, 0L)),
        CRC16_DECT_R(new Parameters(16, 1417L, 0L, false, false, 1L)),
        CRC16_DECT_X(new Parameters(16, 1417L, 0L, false, false, 0L)),
        CRC16_DNP(new Parameters(16, 15717L, 0L, true, true, 65535L)),
        CRC16_EN13757(new Parameters(16, 15717L, 0L, false, false, 65535L)),
        CRC16_GENIBUS(new Parameters(16, 4129L, 65535L, false, false, 65535L)),
        CRC16_MAXIM(new Parameters(16, 32773L, 0L, true, true, 65535L)),
        CRC16_MCRF4XX(new Parameters(16, 4129L, 65535L, true, true, 0L)),
        CRC16_RIELLO(new Parameters(16, 4129L, 45738L, true, true, 0L)),
        CRC16_T10DIF(new Parameters(16, 35767L, 0L, false, false, 0L)),
        CRC16_TELEDISK(new Parameters(16, 41111L, 0L, false, false, 0L)),
        CRC16_TMS37157(new Parameters(16, 4129L, 35308L, true, true, 0L)),
        CRC16_USB(new Parameters(16, 32773L, 65535L, true, true, 65535L)),
        CRC_A(new Parameters(16, 4129L, 50886L, true, true, 0L)),
        CRC16_KERMIT(new Parameters(16, 4129L, 0L, true, true, 0L)),
        CRC16_MODBUS(new Parameters(16, 32773L, 65535L, true, true, 0L)),
        CRC16_X25(new Parameters(16, 4129L, 65535L, true, true, 65535L)),
        CRC16_XMODEM(new Parameters(16, 4129L, 0L, false, false, 0L)),
        CRC32(new Parameters(32, 79764919L, -1L, true, true, -1L)),
        CRC32_BZIP2(new Parameters(32, 79764919L, -1L, false, false, -1L)),
        CRC32C(new Parameters(32, 517762881L, -1L, true, true, -1L)),
        CRC32D(new Parameters(32, -1473013717L, -1L, true, true, -1L)),
        CRC32_MPEG2(new Parameters(32, 79764919L, -1L, false, false, 0L)),
        CRC32_POSIX(new Parameters(32, 79764919L, 0L, false, false, -1L)),
        CRC32Q(new Parameters(32, -2126429781L, 0L, false, false, 0L)),
        CRC32_JAMCRC(new Parameters(32, 79764919L, -1L, true, true, 0L)),
        CRC32_XFER(new Parameters(32, 175L, 0L, false, false, 0L));

        private final Parameters parameters;

        private Algorithm(Parameters parameters) {
            this.parameters = parameters;
        }

        public Parameters getParameters() {
            return this.parameters;
        }
    }
}

