/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.List;

public class Polygon {
    private final Point[] points;

    public Polygon(List<Point> points) {
        this.points = points.toArray(new Point[0]);
    }

    public boolean inPolygon(Point point, ALGORITHM algorithm) {
        return algorithm.inAlgorithm.in(point, this.points);
    }

    public boolean inPolygon(Point point) {
        return this.inPolygon(point, ALGORITHM.TURNOVER);
    }

    static class TurnoverNumberAlgorithm
    implements InAlgorithm {
        TurnoverNumberAlgorithm() {
        }

        @Override
        public boolean in(Point p, Point[] poly) {
            double px = p.x;
            double py = p.y;
            double sum = 0.0;
            int i = 0;
            int l = poly.length;
            int j = l - 1;
            while (i < l) {
                double sx = poly[i].x;
                double sy = poly[i].y;
                double tx = poly[j].x;
                double ty = poly[j].y;
                if ((sx - px) * (px - tx) >= 0.0 && (sy - py) * (py - ty) >= 0.0 && (px - sx) * (ty - sy) == (py - sy) * (tx - sx)) {
                    return true;
                }
                double angle = Math.atan2(sy - py, sx - px) - Math.atan2(ty - py, tx - px);
                if (angle >= Math.PI) {
                    angle -= Math.PI * 2;
                } else if (angle <= -Math.PI) {
                    angle += Math.PI * 2;
                }
                sum += angle;
                j = i++;
            }
            return Math.round(sum / Math.PI) != 0L;
        }
    }

    static class RayAlgorithm
    implements InAlgorithm {
        RayAlgorithm() {
        }

        @Override
        public boolean in(Point p, Point[] poly) {
            double px = p.x;
            double py = p.y;
            boolean flag = false;
            int i = 0;
            int l = poly.length;
            int j = l - 1;
            while (i < l) {
                double sx = poly[i].x;
                double sy = poly[i].y;
                double tx = poly[j].x;
                double ty = poly[j].y;
                if (sx == px && sy == py || tx == px && ty == py) {
                    return true;
                }
                if (sy < py && ty >= py || sy >= py && ty < py) {
                    double x = sx + (py - sy) * (tx - sx) / (ty - sy);
                    if (x == px) {
                        return true;
                    }
                    if (x > px) {
                        flag = !flag;
                    }
                }
                j = i++;
            }
            return flag;
        }
    }

    public static class Point {
        private final double x;
        private final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    static interface InAlgorithm {
        public boolean in(Point var1, Point[] var2);
    }

    public static enum ALGORITHM {
        RAY(new RayAlgorithm()),
        TURNOVER(new TurnoverNumberAlgorithm());

        private final InAlgorithm inAlgorithm;

        private ALGORITHM(InAlgorithm inAlgorithm) {
            this.inAlgorithm = inAlgorithm;
        }
    }
}

