/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.coodex.concurrent.ExecutorServiceImpl;
import org.coodex.util.Clock;

class ScheduledExecutorServiceImpl
extends ExecutorServiceImpl
implements ScheduledExecutorService {
    private final ScheduledExecutorService scheduledExecutorService;

    ScheduledExecutorServiceImpl(ScheduledExecutorService scheduledExecutorService) {
        super(scheduledExecutorService);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        long d = Clock.toMillis(delay, unit);
        return this.scheduledExecutorService.schedule(this.wrapper.wrap(this.wrapRunnable(command), delay, unit), d, TimeUnit.MILLISECONDS);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        long d = Clock.toMillis(delay, unit);
        return this.scheduledExecutorService.schedule(this.wrapper.wrap(this.wrapCallable(callable), delay, unit), d, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        long i = Clock.toMillis(initialDelay, unit);
        long p = Clock.toMillis(period, unit);
        return this.scheduledExecutorService.scheduleAtFixedRate(this.wrapper.wrap(this.wrapRunnable(command), initialDelay, period, unit), i, p, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        long i = Clock.toMillis(initialDelay, unit);
        long d = Clock.toMillis(delay, unit);
        return this.scheduledExecutorService.scheduleAtFixedRate(this.wrapper.wrap(this.wrapRunnable(command), initialDelay, delay, unit), i, d, TimeUnit.MILLISECONDS);
    }
}

