/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.concurrent.FrequencyReducer;
import org.coodex.util.Clock;

public class Throttle
implements FrequencyReducer {
    private final ReentrantLock lock = new ReentrantLock();
    private final long interval;
    private final boolean asyncAlways;
    private final Runnable runnable;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> prevFuture;
    private volatile long prevTimestamp = 0L;

    private Throttle(Builder builder) {
        this.interval = Math.max(0L, builder.interval);
        this.asyncAlways = builder.asyncAlways;
        this.runnable = builder.runnable;
        this.scheduledExecutorService = builder.scheduledExecutorService == null ? (ScheduledExecutorService)DEFAULT_REDUCER_EXECUTOR_SERVICE_SINGLETON.get() : builder.scheduledExecutorService;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void submit() {
        this.submit(this.runnable);
    }

    private long next() {
        return Clock.currentTimeMillis() - this.prevTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable instance is null.");
        }
        this.lock.lock();
        if (this.prevTimestamp == 0L) {
            this.prevTimestamp = Clock.currentTimeMillis();
        }
        try {
            long n;
            if (this.prevFuture != null) {
                this.prevFuture.cancel(true);
                this.prevFuture = null;
            }
            if ((n = this.next()) >= this.interval) {
                this.prevTimestamp = Clock.currentTimeMillis();
                if (this.asyncAlways) {
                    this.scheduledExecutorService.execute(runnable);
                } else {
                    runnable.run();
                }
            } else {
                this.prevFuture = this.scheduledExecutorService.schedule(() -> {
                    this.lock.lock();
                    try {
                        this.prevTimestamp = Clock.currentTimeMillis();
                        runnable.run();
                    }
                    finally {
                        this.prevFuture = null;
                        this.lock.unlock();
                    }
                }, this.interval - n, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class Builder {
        private long interval = 100L;
        private boolean asyncAlways = false;
        private ScheduledExecutorService scheduledExecutorService;
        private Runnable runnable;

        private Builder() {
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        @Deprecated
        public Builder asyncAlways(boolean asyncAlways) {
            this.asyncAlways = asyncAlways;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder runnable(Runnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Throttle build() {
            return new Throttle(this);
        }
    }
}

