/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.components;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToRetryRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ToRetryRunnable.class);
    private final Runnable command;
    private final int maxTimes;
    private int retryTimes = 0;

    public ToRetryRunnable(Runnable command, int maxTimes) {
        this.command = command;
        this.maxTimes = maxTimes;
    }

    @Override
    public void run() {
        try {
            this.command.run();
        }
        catch (Throwable th) {
            ++this.retryTimes;
            if (this.getRetryTimes() < this.getMaxTimes()) {
                this.retry();
            }
            this.onFailed();
        }
    }

    public int getMaxTimes() {
        return this.maxTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    protected abstract void retry();

    protected void onFailed() {
    }
}

