/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoaderProvider;
import org.coodex.util.SingletonMap;

public abstract class AbstractServiceLoaderProvider
implements ServiceLoaderProvider {
    private final SingletonMap<Type, Map<String, Object>> cache = SingletonMap.builder().build();

    @Override
    public Map<String, Object> load(Type serviceType) {
        return this.cache.get(serviceType, () -> {
            if (serviceType instanceof Class) {
                return this.loadByRowType((Class)serviceType);
            }
            if (serviceType instanceof ParameterizedType) {
                HashMap result = new HashMap();
                this.loadByRowType((Class)((ParameterizedType)serviceType).getRawType()).forEach((key, object) -> {
                    if (object != null && ReflectHelper.isMatch(object.getClass(), serviceType)) {
                        result.put(key, object);
                    }
                });
                return result;
            }
            return new HashMap();
        });
    }

    protected abstract Map<String, Object> loadByRowType(Class<?> var1);
}

