/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class FriendlyNumbers {
    public static final FriendlyNumbers THOUSAND_BASE = new FriendlyNumbers(new Param().add(1000L, "", 1L).add(1000000L, "K", 1000L).add(1000000000L, "M", 1000000L).add(1000000000000L, "B", 1000000000L).add(1000000000000000L, "T", 1000000000000L));
    private final Param param;
    private List<ParamItem> items = null;

    public FriendlyNumbers(Param param) {
        this.param = param;
    }

    public static void main(String[] args) {
        Arrays.asList(599, 14599, 19999, 20001894123L, 99999999999L).forEach(l -> System.out.println("friendly " + l + ": " + THOUSAND_BASE.format(l.longValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long value) {
        if (this.items == null || this.param.changed) {
            FriendlyNumbers friendlyNumbers = this;
            synchronized (friendlyNumbers) {
                if (this.items == null || this.param.changed) {
                    this.items = new ArrayList<ParamItem>(this.param.paramItems);
                    this.items.sort(ParamItem::compareTo);
                    this.param.changed = false;
                }
            }
        }
        long v = Math.abs(value);
        Optional<ParamItem> item = this.items.stream().filter(paramItem -> ((ParamItem)paramItem).maxRange > v).findFirst();
        if (!item.isPresent()) {
            return String.valueOf(value);
        }
        ParamItem paramItem2 = item.get();
        if (paramItem2.divisor == 1L) {
            return String.valueOf(value);
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(v);
        String[] numbers = (bigDecimal = bigDecimal.divide(BigDecimal.valueOf(paramItem2.divisor), this.param.scale, RoundingMode.HALF_UP)).toString().split("\\.");
        if (numbers.length == 2) {
            byte[] x = numbers[1].getBytes();
            for (int i = x.length - 1; i >= 0; --i) {
                if (x[i] == 48) continue;
                numbers[0] = numbers[0] + "." + new String(x, 0, i + 1, StandardCharsets.UTF_8);
                break;
            }
        }
        return numbers[0] + paramItem2.units;
    }

    public static class Param {
        private final int scale;
        private boolean changed = true;
        private List<ParamItem> paramItems = new ArrayList<ParamItem>();

        public Param() {
            this(1);
        }

        public Param(int scale) {
            this.scale = Math.abs(scale);
        }

        public Param add(long maxRange, String units, long divisor) {
            this.paramItems.add(new ParamItem(maxRange, units, divisor));
            this.changed = true;
            return this;
        }
    }

    static class ParamItem
    implements Comparable<ParamItem> {
        private final long maxRange;
        private final String units;
        private final long divisor;

        ParamItem(long maxRange, String units, long divisor) {
            if (divisor == 0L) {
                throw new IllegalArgumentException("divisor not be zero.");
            }
            this.maxRange = Math.abs(maxRange);
            this.units = units;
            this.divisor = Math.abs(divisor);
        }

        private int toInt(long l) {
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }

        @Override
        public int compareTo(ParamItem o) {
            return o == null ? 1 : this.toInt(this.maxRange - o.maxRange);
        }
    }
}

