/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.coodex.util.AbstractTranslateService;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.ResourceScanner;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileBasedTranslateService
extends AbstractTranslateService {
    private static final Logger log = LoggerFactory.getLogger(ProfileBasedTranslateService.class);
    private final List<ResourcesMapper> mappers = new LinkedList<ResourcesMapper>();
    private final SingletonMap<CacheKey, String> translateCache = SingletonMap.builder().function(key -> this.get(((CacheKey)key).key, ((CacheKey)key).locale)).build();

    ProfileBasedTranslateService() {
        ResourceScanner.newBuilder((resource, resourceName) -> this.mappers.add(new ResourcesMapper((String)resourceName, (URL)resource, Integer.MAX_VALUE - (ResourceScanner.isExtraPath() ? ResourceScanner.getExtraPathIndex() : 0)))).filter(resourceName -> {
            String[] allSupported;
            for (String ext : allSupported = Profile.allSupportedFileExt()) {
                if (!resourceName.endsWith(ext)) continue;
                return true;
            }
            return false;
        }).extraPath(true).build().scan("i18n");
    }

    private static int countOfSlash(String resourceName) {
        int count = 0;
        for (char ch : resourceName.toCharArray()) {
            if (ch != '/') continue;
            ++count;
        }
        return count;
    }

    @Override
    protected String translateIfExits(String key, Locale locale) {
        return this.translateCache.get(new CacheKey(key, locale));
    }

    private boolean in(String key, String name) {
        if (key.equals(name)) {
            return true;
        }
        return key.startsWith(name + ".");
    }

    private String get(String key, Locale locale) {
        LinkedList<ResourcesMapper> list = new LinkedList<ResourcesMapper>();
        for (ResourcesMapper mapper : this.mappers) {
            if (!mapper.accept(locale) || !this.in(key, mapper.name)) continue;
            list.add(mapper);
        }
        if (list.size() > 0) {
            Object[] mapperArray = list.toArray(new ResourcesMapper[0]);
            Arrays.sort(mapperArray);
            for (Object mapper : mapperArray) {
                String value = Profile.get(((ResourcesMapper)mapper).resource).getString(key);
                if (value == null) continue;
                log.debug("{}[{}]:{} load from {}", new Object[]{key, locale, value, ((ResourcesMapper)mapper).resource.toString()});
                return value;
            }
        }
        log.debug("{} not found.", (Object)key);
        return null;
    }

    private static class CacheKey {
        private final String key;
        private final Locale locale;

        CacheKey(String key, Locale locale) {
            this.key = key;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!Objects.equals(this.key, cacheKey.key)) {
                return false;
            }
            return Objects.equals(this.locale, cacheKey.locale);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CacheKey{key='" + this.key + '\'' + ", locale=" + this.locale + '}';
        }
    }

    private static class ResourcesMapper
    implements Comparable<ResourcesMapper> {
        private final String path;
        private final Boolean isFile;
        private final String ext;
        private final int deep;
        private final URL resource;
        private final int fileOrder;
        private String name;
        private String language = null;
        private String country = null;

        ResourcesMapper(String resourceName, URL resource, int fileOrder) {
            String test;
            this.resource = resource;
            this.isFile = resource.toString().startsWith("file:");
            this.fileOrder = fileOrder;
            this.deep = ProfileBasedTranslateService.countOfSlash(resourceName);
            int indexEnd = resourceName.lastIndexOf(46);
            int indexStart = resourceName.lastIndexOf(47);
            this.name = resourceName.substring(indexStart + 1, indexEnd);
            this.ext = resourceName.substring(indexEnd);
            this.path = resourceName.substring(0, indexStart);
            if (this.name.length() > 3 && this.name.charAt(this.name.length() - 3) == '_' && Common.inArray(test = this.name.substring(this.name.length() - 2).toUpperCase(), Locale.getISOCountries())) {
                this.country = test;
                this.name = this.name.substring(0, this.name.length() - 3);
            }
            if (this.name.length() > 3 && this.name.charAt(this.name.length() - 3) == '_' && Common.inArray(test = this.name.substring(this.name.length() - 2).toLowerCase(), Locale.getISOLanguages())) {
                this.language = test;
                this.name = this.name.substring(0, this.name.length() - 3);
            }
        }

        boolean accept(Locale locale) {
            if (this.language == null) {
                return true;
            }
            if (this.country == null && locale.getLanguage().equals(this.language)) {
                return true;
            }
            return locale.getLanguage().equals(this.language) && locale.getCountry().equals(this.country);
        }

        @Override
        public int compareTo(ResourcesMapper o) {
            int x = this.isFile.compareTo(o.isFile);
            if (x != 0) {
                return -x;
            }
            x = this.fileOrder - o.fileOrder;
            if (x != 0) {
                return -x;
            }
            x = this.name.length() - o.name.length();
            if (x != 0) {
                return -x;
            }
            x = this.deep - o.deep;
            if (x != 0) {
                return -x;
            }
            x = this.path.compareTo(o.path);
            if (x != 0) {
                return x;
            }
            if (this.language == null && o.language != null) {
                return 1;
            }
            if (this.language != null && o.language == null) {
                return -1;
            }
            if (this.country == null && o.country != null) {
                return 1;
            }
            if (this.country != null && o.country == null) {
                return -1;
            }
            x = Common.indexOf(Profile.allSupportedFileExt(), this.ext) - Common.indexOf(Profile.allSupportedFileExt(), o.ext);
            if (x != 0) {
                return x;
            }
            x = this.ext.compareTo(o.ext);
            if (x != 0) {
                return -x;
            }
            return this.resource.toString().compareTo(o.resource.toString());
        }
    }
}

