/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.coodex.concurrent.ExecutableWrapper;
import org.coodex.concurrent.ExecutableWrapperImpl;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutorServiceImpl
implements ExecutorService {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceImpl.class);
    private static final ServiceLoader<ExecutableWrapper> executableWrapperLoader = new LazyServiceLoader<ExecutableWrapper>((ExecutableWrapper)new ExecutableWrapperImpl()){};
    protected final ExecutableWrapper wrapper;
    private final ExecutorService executorService;

    ExecutorServiceImpl(ExecutorService executorService) {
        this.executorService = executorService;
        this.wrapper = executableWrapperLoader.get();
    }

    <V> Collection<? extends Callable<V>> wrap(Collection<? extends Callable<V>> coll) {
        ArrayList<Callable<V>> list = new ArrayList<Callable<V>>();
        for (Callable<V> c : coll) {
            list.add(this.wrapper.wrap(c));
        }
        return list;
    }

    protected Runnable wrapRunnable(Runnable runnable) {
        return runnable == null ? null : () -> {
            try {
                runnable.run();
            }
            catch (Throwable th) {
                log.warn("Runnable run failed: {}", (Object)th.getLocalizedMessage(), (Object)th);
            }
        };
    }

    protected <V> Callable<V> wrapCallable(Callable<V> callable) {
        return callable == null ? null : () -> {
            try {
                return callable.call();
            }
            catch (Throwable th) {
                log.warn("Callable call failed: {}", (Object)th.getLocalizedMessage(), (Object)th);
                throw th;
            }
        };
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(this.wrapper.wrap(this.wrapCallable(task)));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(this.wrapper.wrap(this.wrapRunnable(task)), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(this.wrapper.wrap(this.wrapRunnable(task)));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(this.wrap(tasks.stream().map(this::wrapCallable).collect(Collectors.toList())));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(this.wrap(tasks.stream().map(this::wrapCallable).collect(Collectors.toList())), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.executorService.invokeAny(this.wrap(tasks.stream().map(this::wrapCallable).collect(Collectors.toList())));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.executorService.invokeAny(this.wrap(tasks.stream().map(this::wrapCallable).collect(Collectors.toList())), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(this.wrapper.wrap(this.wrapRunnable(command)));
    }
}

