/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.coodex.concurrent.ExecutorWrapper;
import org.coodex.concurrent.components.PriorityRunnable;

public class ExecutorsHelper {
    private ExecutorsHelper() {
    }

    private static PriorityRunnable getPriorityRunnable(Runnable runnable) {
        return runnable instanceof PriorityRunnable ? (PriorityRunnable)runnable : new PriorityRunnable(5, runnable);
    }

    public static ExecutorService newPriorityThreadPool(int coreSize, int maxSize, int maxWait, String namePrefix, int threadPriority) {
        return ExecutorsHelper.newPriorityThreadPool(coreSize, maxSize, maxWait, 60L, namePrefix, threadPriority);
    }

    public static ExecutorService newPriorityThreadPool(int coreSize, int maxSize, int maxWait, String namePrefix) {
        return ExecutorsHelper.newPriorityThreadPool(coreSize, maxSize, maxWait, namePrefix, 5);
    }

    public static ExecutorService newPriorityThreadPool(int coreSize, int maxSize, int maxWait, long keepAliveTime, String namePrefix) {
        return ExecutorsHelper.newPriorityThreadPool(coreSize, maxSize, maxWait, keepAliveTime, namePrefix, 5);
    }

    public static ExecutorService newPriorityThreadPool(int coreSize, int maxSize, int maxWait, long keepAliveTime, String namePrefix, int threadPriority) {
        PoolSize poolSize = new PoolSize(coreSize, maxSize).invoke();
        return ExecutorsHelper.newThreadPool(keepAliveTime, namePrefix, poolSize, new CoodexPriorityBlockingQueue(maxWait), threadPriority);
    }

    private static ExecutorService newThreadPool(long keepAliveTime, String namePrefix, PoolSize poolSize, CoodexBlockingQueue priorityBlockingQueue, int priority) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(poolSize.getFinalCoreSize(), poolSize.getFinalMaxSize(), keepAliveTime, TimeUnit.SECONDS, (BlockingQueue)priorityBlockingQueue, (ThreadFactory)new DefaultNamedThreadFactory(namePrefix, priority)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Runnable command) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    super.execute(command);
                }
            }
        };
        priorityBlockingQueue.setThreadPoolExecutor(threadPool);
        return ExecutorWrapper.wrap(threadPool);
    }

    public static ExecutorService newLinkedThreadPool(int coreSize, int maxSize, int maxWait, String namePrefix) {
        return ExecutorsHelper.newLinkedThreadPool(coreSize, maxSize, maxWait, namePrefix, 5);
    }

    public static ExecutorService newLinkedThreadPool(int coreSize, int maxSize, int maxWait, String namePrefix, int threadPriority) {
        return ExecutorsHelper.newLinkedThreadPool(coreSize, maxSize, maxWait, 60L, namePrefix, threadPriority);
    }

    public static ExecutorService newLinkedThreadPool(int coreSize, int maxSize, int maxWait, long keepAliveTime, String namePrefix) {
        return ExecutorsHelper.newLinkedThreadPool(coreSize, maxSize, maxWait, keepAliveTime, namePrefix, 5);
    }

    public static ExecutorService newLinkedThreadPool(int coreSize, int maxSize, int maxWait, long keepAliveTime, String namePrefix, int threadPriority) {
        PoolSize poolSize = new PoolSize(coreSize, maxSize).invoke();
        return ExecutorsHelper.newThreadPool(keepAliveTime, namePrefix, poolSize, new CoodexLinkedBlockingQueue(maxWait), threadPriority);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String namePrefix) {
        return ExecutorsHelper.newFixedThreadPool(nThreads, namePrefix, 5);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String namePrefix, int priority) {
        return ExecutorsHelper.newFixedThreadPool(nThreads, new DefaultNamedThreadFactory(namePrefix, priority));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newFixedThreadPool(nThreads, threadFactory));
    }

    public static ExecutorService newSingleThreadExecutor(String namePrefix) {
        return ExecutorsHelper.newSingleThreadExecutor(namePrefix, 5);
    }

    public static ExecutorService newSingleThreadExecutor(String namePrefix, int priority) {
        return ExecutorsHelper.newSingleThreadExecutor(new DefaultNamedThreadFactory(namePrefix, priority));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newSingleThreadExecutor(threadFactory));
    }

    public static ExecutorService newCachedThreadPool(String namePrefix) {
        return ExecutorsHelper.newCachedThreadPool(namePrefix, 5);
    }

    public static ExecutorService newCachedThreadPool(String namePrefix, int priority) {
        return ExecutorsHelper.newCachedThreadPool(new DefaultNamedThreadFactory(namePrefix, priority));
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newCachedThreadPool(threadFactory));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String namePrefix) {
        return ExecutorsHelper.newSingleThreadScheduledExecutor(namePrefix, 5);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String namePrefix, int priority) {
        return ExecutorsHelper.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory(namePrefix, priority));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newSingleThreadScheduledExecutor(threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String namePrefix) {
        return ExecutorsHelper.newScheduledThreadPool(corePoolSize, namePrefix, 5);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String namePrefix, int priority) {
        return ExecutorsHelper.newScheduledThreadPool(corePoolSize, new DefaultNamedThreadFactory(namePrefix, priority));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return ExecutorWrapper.wrap(Executors.newScheduledThreadPool(corePoolSize, threadFactory));
    }

    public static void shutdownAll() {
        ExecutorWrapper.shutdown();
    }

    public static List<Runnable> shutdownAllNOW() {
        return ExecutorWrapper.shutdownNow();
    }

    private static class PoolSize {
        private final int coreSize;
        private final int maxSize;
        private int finalCoreSize;
        private int finalMaxSize;

        public PoolSize(int coreSize, int maxSize) {
            this.coreSize = coreSize;
            this.maxSize = maxSize;
        }

        public int getFinalCoreSize() {
            return this.finalCoreSize;
        }

        public int getFinalMaxSize() {
            return this.finalMaxSize;
        }

        public PoolSize invoke() {
            this.finalCoreSize = Math.max(this.coreSize, 1);
            this.finalMaxSize = Math.max(this.maxSize, this.coreSize);
            return this;
        }
    }

    static class CoodexPriorityBlockingQueue
    extends PriorityBlockingQueue<Runnable>
    implements CoodexBlockingQueue {
        private final int maximumSize;
        private ThreadPoolExecutor threadPoolExecutor;

        CoodexPriorityBlockingQueue(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        @Override
        public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public boolean offer(Runnable runnable) {
            runnable = ExecutorsHelper.getPriorityRunnable(runnable);
            return this.threadPoolExecutor.getPoolSize() >= this.threadPoolExecutor.getMaximumPoolSize() && this.size() < this.maximumSize && super.offer(runnable);
        }
    }

    static interface CoodexBlockingQueue
    extends BlockingQueue<Runnable> {
        public void setThreadPoolExecutor(ThreadPoolExecutor var1);
    }

    static class DefaultNamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        @Deprecated
        DefaultNamedThreadFactory(String namePrefix) {
            this(namePrefix, 5);
        }

        DefaultNamedThreadFactory(String namePrefix, int priority) {
            this.priority = Math.min(10, Math.max(1, priority));
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix == null ? "coodex-pool-" + poolNumber.getAndIncrement() + "-thread" : namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }

    static class CoodexLinkedBlockingQueue
    extends LinkedBlockingQueue<Runnable>
    implements CoodexBlockingQueue {
        private final int maximumSize;
        private ThreadPoolExecutor threadPoolExecutor;

        public CoodexLinkedBlockingQueue(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        @Override
        public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.threadPoolExecutor.getPoolSize() >= this.threadPoolExecutor.getMaximumPoolSize() && this.size() < this.maximumSize && super.offer(runnable);
        }
    }
}

