/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry {
    private static final Logger log = LoggerFactory.getLogger(Retry.class);
    private static final Integer DEFAULT_MAX_TIMES = 5;
    private static final NextDelay DEFAULT_NEXT_DELAY = new TimeUnitNextDelay(TimeUnit.SECONDS){

        @Override
        protected long delay(int times) {
            return 5L;
        }
    };
    private static final Singleton<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_SINGLETON = Singleton.with(() -> ExecutorsHelper.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2, "retry"));
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;
    private Integer maxTimes;
    private long initDelay = 0L;
    private NextDelay nextDelay;
    private Supplier<String> taskNameSupplier = null;
    private OnFailed onFailed = null;
    private AllFailedHandle allFailedHandle = null;
    private int num = 1;
    private Status status = Status.INIT;
    private Task task;
    private Long start;

    private Retry() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void execute(Runnable runnable) {
        this.execute((int times) -> {
            runnable.run();
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        if (task == null) {
            throw new NullPointerException("task is null.");
        }
        Retry retry = this;
        synchronized (retry) {
            if (!Status.INIT.equals((Object)this.status)) {
                throw new IllegalStateException("task has scheduled.");
            }
            this.task = task;
            this.status = Status.WAITING;
        }
        this.postTask();
    }

    public void execute() {
        this.execute(this.task);
    }

    private String getTaskName() {
        return this.taskNameSupplier == null ? this.task.toString() : this.taskNameSupplier.get();
    }

    private void postTask() {
        Runnable toPost = () -> {
            Retry retry = this;
            synchronized (retry) {
                if (Status.FINISHED.equals((Object)this.status)) {
                    return;
                }
                this.status = Status.RUNNING;
                if (this.start == null) {
                    this.start = Clock.currentTimeMillis();
                }
                long thisTimes = Clock.currentTimeMillis();
                int times = this.num++;
                Throwable throwable = null;
                boolean success = false;
                try {
                    success = this.task.run(times);
                }
                catch (Throwable th) {
                    throwable = th;
                }
                finally {
                }
                if (success || this.num > this.maxTimes) {
                    this.status = Status.FINISHED;
                    if (success) {
                        if (log.isDebugEnabled()) {
                            log.debug("{} success. [{}]", (Object)this.getTaskName(), (Object)times);
                        }
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info("{} all failed.", (Object)this.getTaskName());
                        }
                        this.onFailed(Common.longToCalendar(thisTimes), times, throwable);
                        if (this.allFailedHandle != null) {
                            try {
                                this.allFailedHandle.allFailed(Common.longToCalendar(this.start), times);
                            }
                            catch (Throwable t) {
                                log.warn("handle error.", t);
                            }
                        }
                    }
                } else {
                    this.onFailed(Common.longToCalendar(thisTimes), times, throwable);
                    if (throwable != null && log.isWarnEnabled()) {
                        log.warn("{} failed [{}] times. {}", new Object[]{this.getTaskName(), times, throwable.getLocalizedMessage(), throwable});
                    }
                    if (throwable == null && log.isInfoEnabled()) {
                        log.info("{} failed [{}] times.", (Object)this.getTaskName(), (Object)times);
                    }
                    this.status = Status.WAITING;
                    this.postTask();
                }
            }
        };
        if (this.executorService != null) {
            Runnable tmp = toPost;
            toPost = () -> this.executorService.execute(tmp);
        }
        this.scheduledExecutorService.schedule(toPost, this.num == 1 ? this.initDelay : Clock.toMillis(this.nextDelay.next(this.num), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public void onFailed(Calendar start, int times, Throwable throwable) {
        if (this.onFailed != null) {
            try {
                this.onFailed.onFailed(start, times, throwable);
            }
            catch (Throwable t) {
                log.warn("on failed handle error.", t);
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public static interface AllFailedHandle {
        public void allFailed(Calendar var1, int var2);
    }

    public static interface OnFailed {
        public void onFailed(Calendar var1, int var2, Throwable var3);
    }

    public static interface NextDelay {
        public long next(int var1);
    }

    public static enum Status {
        INIT(0),
        WAITING(1),
        RUNNING(2),
        FINISHED(3);

        private final int status;

        private Status(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static class Builder {
        private ScheduledExecutorService scheduledExecutorService;
        private ExecutorService executorService;
        private Integer maxTimes;
        private long initDelay = 0L;
        private NextDelay nextDelay;
        private Supplier<String> taskNameSupplier = null;
        private OnFailed onFailed = null;
        private AllFailedHandle allFailedHandle = null;

        private Builder() {
        }

        public Builder scheduler(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder executor(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder maxTimes(int maxRetryTimes) {
            if (maxRetryTimes < 1) {
                throw new IllegalArgumentException("illegal maxRetryTimes: " + maxRetryTimes);
            }
            this.maxTimes = maxRetryTimes;
            return this;
        }

        public Builder initDelay(long initDelay, TimeUnit unit) {
            this.initDelay = unit.toMillis(initDelay);
            return this;
        }

        public Builder next(NextDelay nextDelay) {
            this.nextDelay = nextDelay;
            return this;
        }

        public Builder named(String name) {
            this.taskNameSupplier = () -> name;
            return this;
        }

        public Builder named(Supplier<String> taskNameSupplier) {
            this.taskNameSupplier = taskNameSupplier;
            return this;
        }

        public Builder onFailed(OnFailed onFailed) {
            this.onFailed = onFailed;
            return this;
        }

        public Builder onAllFailed(AllFailedHandle allFailedHandle) {
            this.allFailedHandle = allFailedHandle;
            return this;
        }

        public Retry build() {
            Retry retry = new Retry();
            retry.initDelay = this.initDelay;
            retry.maxTimes = this.maxTimes == null ? DEFAULT_MAX_TIMES : this.maxTimes;
            retry.nextDelay = this.nextDelay == null ? DEFAULT_NEXT_DELAY : this.nextDelay;
            retry.scheduledExecutorService = this.scheduledExecutorService == null ? (ScheduledExecutorService)SCHEDULED_EXECUTOR_SERVICE_SINGLETON.get() : this.scheduledExecutorService;
            retry.executorService = this.executorService;
            retry.taskNameSupplier = this.taskNameSupplier;
            retry.onFailed = this.onFailed;
            retry.allFailedHandle = this.allFailedHandle;
            return retry;
        }
    }

    public static interface Task {
        public boolean run(int var1) throws Throwable;
    }

    public static abstract class TimeUnitNextDelay
    implements NextDelay {
        private final TimeUnit unit;

        protected TimeUnitNextDelay(TimeUnit unit) {
            this.unit = unit;
        }

        protected abstract long delay(int var1);

        @Override
        public long next(int times) {
            return this.unit.toMillis(this.delay(times));
        }
    }
}

