/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Level {
    NONE,
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;

    private static final Logger logger;

    public static Level parse(String levelName) {
        try {
            return Level.valueOf(Level.class, levelName.toUpperCase());
        }
        catch (Throwable th) {
            if (!levelName.equalsIgnoreCase("NONE")) {
                logger.warn(th.getLocalizedMessage());
            }
            return NONE;
        }
    }

    public boolean isEnabled(Logger log) {
        switch (this) {
            case NONE: {
                return false;
            }
            case TRACE: {
                return log.isTraceEnabled();
            }
            case DEBUG: {
                return log.isDebugEnabled();
            }
            case INFO: {
                return log.isInfoEnabled();
            }
            case WARN: {
                return log.isWarnEnabled();
            }
            case ERROR: {
                return log.isErrorEnabled();
            }
        }
        return false;
    }

    public void log(Logger log, String str) {
        if (this == NONE) {
            return;
        }
        try {
            Method method = Logger.class.getMethod(this.name().toLowerCase(), String.class);
            method.setAccessible(true);
            method.invoke((Object)log, str);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    static {
        logger = LoggerFactory.getLogger(Level.class);
    }
}

