/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReentrantLock;
import org.coodex.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(FileCache.class);
    private static final int MAX_FILE_SIZE = 262144;
    private final File dir;
    private final String node;
    private final String name;
    private final Index index = new Index();
    private final ReentrantLock lock = new ReentrantLock();

    public FileCache(String node, String name) {
        this.node = node;
        this.name = name;
        this.dir = new File(node + "/" + name);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        this.index.load();
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int cachedItems() {
        this.lock.lock();
        try {
            int n = this.index.cached;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] next() {
        this.lock.lock();
        try {
            byte[] byArray;
            if (this.index.cached == 0) {
                byte[] byArray2 = null;
                return byArray2;
            }
            File file = this.file(this.index.readFile);
            if (!file.exists()) {
                byte[] byArray3 = null;
                return byArray3;
            }
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                raf.seek(this.index.readOffset);
                int length = raf.readUnsignedShort();
                byte[] data = new byte[length];
                raf.readFully(data);
                this.index.readOffset += 2 + length;
                --this.index.cached;
                if ((long)this.index.readOffset >= raf.length()) {
                    if (this.index.readFile == this.index.writeFile) {
                        this.index.readOffset = 0;
                        this.index.writeOffset = 0;
                        raf.close();
                        if (this.index.readFile != 0) {
                            this.index.writeFile = 0;
                            this.index.readFile = 0;
                            file.delete();
                        }
                        try (RandomAccessFile wraf = new RandomAccessFile(this.file(this.index.readFile), "rw");){
                            wraf.setLength(0L);
                        }
                    } else {
                        file.delete();
                        this.index.readFile = this.index.readFile + 1 & 0xFFFFFFF;
                        this.index.readOffset = 0;
                    }
                }
                this.index.save();
                byArray = data;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    byte[] byArray4 = null;
                    return byArray4;
                }
            }
            raf.close();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cache(byte[] bytes) {
        this.cache(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(byte[] data, int offset, int length) {
        if (length > 65536) {
            throw new IllegalArgumentException("Data too large");
        }
        this.lock.lock();
        try {
            File file = this.file(this.index.writeFile);
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                raf.seek(this.index.writeOffset);
                raf.writeByte(length >> 8 & 0xFF);
                raf.writeByte(length & 0xFF);
                raf.write(data, offset, length);
                this.index.writeOffset += 2 + length;
                ++this.index.cached;
                if (this.index.writeOffset >= 262144) {
                    this.index.writeFile = this.index.writeFile + 1 & 0xFFFFFFF;
                    this.index.writeOffset = 0;
                }
                this.index.save();
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private File file(int id) {
        return new File(this.dir, String.format("%08X", id));
    }

    class Index {
        int readFile = 1;
        int writeFile = 1;
        int readOffset = 0;
        int writeOffset = 0;
        int cached = 0;

        Index() {
        }

        void save() {
            File file = new File(FileCache.this.dir, "index");
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(file));){
                out.writeInt(this.readFile);
                out.writeInt(this.readOffset);
                out.writeInt(this.writeFile);
                out.writeInt(this.writeOffset);
                out.writeInt(this.cached);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void load() {
            File file = new File(FileCache.this.dir, "index");
            if (!file.exists()) {
                return;
            }
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                this.readFile = in.readInt();
                this.readOffset = in.readInt();
                this.writeFile = in.readInt();
                this.writeOffset = in.readInt();
                this.cached = in.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

