/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.count;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.coodex.count.Countable;
import org.coodex.count.Counter;
import org.coodex.count.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CounterChain<T extends Countable>
implements Counter<T> {
    private static final Logger log = LoggerFactory.getLogger(CounterChain.class);
    private final List<Counter<T>> counters = new ArrayList<Counter<T>>();

    public void addCounter(Counter<T> counter) {
        if (counter != null && !this.counters.contains(counter) && !CounterChain.class.isAssignableFrom(counter.getClass())) {
            this.counters.add(counter);
        }
    }

    protected abstract Executor getThreadPool();

    private boolean isSync(Counter<T> counter) {
        return counter.getClass().getAnnotation(Sync.class) != null;
    }

    @Override
    public void count(T value) {
        if (value != null && !this.counters.isEmpty()) {
            for (final Counter<T> counter : this.counters) {
                Runnable runnable = new Runnable(){
                    final /* synthetic */ Countable val$value;
                    {
                        this.val$value = countable;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Counter counter2 = counter;
                        synchronized (counter2) {
                            try {
                                counter.count(this.val$value);
                            }
                            catch (Throwable th) {
                                log.warn("count failed. {}, {}", new Object[]{counter.getClass().getName(), th.getLocalizedMessage(), th});
                            }
                        }
                    }
                };
                if (this.isSync(counter)) {
                    runnable.run();
                    continue;
                }
                this.getThreadPool().execute(runnable);
            }
        }
    }
}

