/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509TrustManagerImpl
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(X509TrustManagerImpl.class);
    private final X509TrustManager trustManager;
    private final KeyStore keyStore;

    X509TrustManagerImpl(InputStream certFile) throws Exception {
        this.keyStore = this.initKeyStore(certFile);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagers[0];
    }

    private KeyStore initKeyStore(InputStream file) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(file);
        trustStore.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
        return trustStore;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block7: {
            try {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException certificateException) {
                CertificateNotYetValidException certificateNotYetValidException;
                block6: {
                    certificateNotYetValidException = null;
                    try {
                        X509Certificate[] reorderedChain = this.reorderCertificateChain(chain);
                        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                        CertificateFactory factory = CertificateFactory.getInstance("X509");
                        CertPath certPath = factory.generateCertPath(Arrays.asList(reorderedChain));
                        PKIXParameters params = new PKIXParameters(this.keyStore);
                        params.setRevocationEnabled(false);
                        validator.validate(certPath, params);
                    }
                    catch (CertificateNotYetValidException e) {
                        certificateNotYetValidException = e;
                    }
                    catch (Throwable th) {
                        Throwable caused = th.getCause();
                        if (caused instanceof CertificateNotYetValidException) {
                            certificateNotYetValidException = (CertificateNotYetValidException)caused;
                            break block6;
                        }
                        throw certificateException;
                    }
                }
                if (certificateNotYetValidException == null) break block7;
                log.warn("certificate not yet valid.", (Throwable)certificateNotYetValidException);
            }
        }
    }

    private X509Certificate[] reorderCertificateChain(X509Certificate[] chain) {
        X509Certificate rootCert;
        X509Certificate[] reorderedChain = new X509Certificate[chain.length];
        List<X509Certificate> certificates = Arrays.asList(chain);
        int position = chain.length - 1;
        reorderedChain[position] = rootCert = this.findRootCert(certificates);
        X509Certificate cert = rootCert;
        while ((cert = this.findSignedCert(cert, certificates)) != null && position > 0) {
            reorderedChain[--position] = cert;
        }
        return reorderedChain;
    }

    private X509Certificate findRootCert(List<X509Certificate> certificates) {
        X509Certificate rootCert = null;
        for (X509Certificate cert : certificates) {
            X509Certificate signer = this.findSigner(cert, certificates);
            if (signer != null && !signer.equals(cert)) continue;
            rootCert = cert;
            break;
        }
        return rootCert;
    }

    private X509Certificate findSignedCert(X509Certificate signingCert, List<X509Certificate> certificates) {
        if (signingCert == null || certificates == null) {
            return null;
        }
        X509Certificate signed = null;
        for (X509Certificate cert : certificates) {
            X500Principal signingCertSubjectDN = signingCert.getSubjectX500Principal();
            X500Principal certIssuerDN = cert.getIssuerX500Principal();
            if (!certIssuerDN.equals(signingCertSubjectDN) || cert.equals(signingCert)) continue;
            signed = cert;
            break;
        }
        return signed;
    }

    private X509Certificate findSigner(X509Certificate signedCert, List<X509Certificate> certificates) {
        X509Certificate signer = null;
        for (X509Certificate cert : certificates) {
            X500Principal issuerDN;
            X500Principal certSubjectDN = cert.getSubjectX500Principal();
            if (!certSubjectDN.equals(issuerDN = signedCert.getIssuerX500Principal())) continue;
            signer = cert;
            break;
        }
        return signer;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

