/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.coodex.util.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ProfileBaseYaml
extends Profile {
    private static final Logger log = LoggerFactory.getLogger(ProfileBaseYaml.class);
    private final Map<String, Object> valuesMap = new HashMap<String, Object>();

    ProfileBaseYaml(URL url) {
        try {
            this.init(url);
        }
        catch (IOException e) {
            log.warn("init [{}] yaml profile failed", (Object)url, (Object)e);
        }
    }

    private void init(URL url) throws IOException {
        Yaml yaml = new Yaml();
        if (url != null) {
            try (InputStream is = url.openStream();){
                Map map = (Map)yaml.load(is);
                this.map(null, map);
            }
        }
    }

    private void map(String prefix, Map<Object, Object> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = prefix == null ? entry.getKey().toString() : prefix + "." + entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) {
                this.valuesMap.put(key, null);
            }
            if (value instanceof Map) {
                this.map(key, (Map)value);
                continue;
            }
            this.valuesMap.put(key, value);
        }
    }

    private String toString(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type.isArray()) {
            Object[] array = (Object[])o;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(array[i]));
            }
            return builder.toString();
        }
        if (Collection.class.isAssignableFrom(type)) {
            boolean appendSP = false;
            StringBuilder builder = new StringBuilder();
            for (Object el : (Collection)o) {
                if (appendSP) {
                    builder.append(", ");
                } else {
                    appendSP = true;
                }
                builder.append(this.toString(el));
            }
            return builder.toString();
        }
        return o.toString();
    }

    @Override
    public String getStringImpl(String key) {
        Object o = this.valuesMap.get(key);
        if (o == null) {
            return null;
        }
        return this.toString(o);
    }

    @Override
    protected boolean isNull(String key) {
        return this.valuesMap.get(key) == null;
    }

    @Override
    public boolean getBool(String key, boolean v) {
        Object o = this.valuesMap.get(key);
        if (o == null) {
            return v;
        }
        if (o.getClass().equals(Boolean.class)) {
            return (Boolean)o;
        }
        return super.getBool(key, v);
    }

    @Override
    public int getInt(String key, int v) {
        return super.getInt(key, v);
    }

    @Override
    public long getLong(String key, long v) {
        return super.getLong(key, v);
    }

    @Override
    public String[] getStrList(String key, String delim, String[] v) {
        return super.getStrList(key, delim, v);
    }
}

