/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.Objects;
import org.coodex.util.Searchable;

public class SearchableHelper {
    public static <E> int indexOf(Searchable<E> searchable, int fromIndex, int toIndex, E[] elements) {
        int first;
        if (elements == null || elements.length == 0) {
            return fromIndex;
        }
        if (elements.length == 1) {
            return searchable.indexOf(fromIndex, toIndex, elements[0]);
        }
        int len = elements.length;
        if (fromIndex + len > toIndex) {
            return -1;
        }
        while (fromIndex + len <= toIndex && (first = searchable.indexOf(fromIndex, toIndex - len + 1, elements[0])) >= 0) {
            boolean ok = true;
            for (int i = 1; i < len; ++i) {
                if (Objects.equals(elements[i], searchable.get(first + i))) continue;
                ok = false;
                break;
            }
            if (ok) {
                return first;
            }
            fromIndex = first + 1;
        }
        return -1;
    }

    public static int indexOf_int(Searchable<Integer> searchable, int fromIndex, int toIndex, int[] elements) {
        if (elements == null || elements.length == 0) {
            return fromIndex;
        }
        Integer[] integers = new Integer[elements.length];
        int l = integers.length;
        for (int i = 0; i < l; ++i) {
            integers[i] = elements[i];
        }
        return SearchableHelper.indexOf(searchable, fromIndex, toIndex, integers);
    }

    public static int indexOf_byte(Searchable<Byte> searchable, int fromIndex, int toIndex, byte[] elements) {
        if (elements == null || elements.length == 0) {
            return fromIndex;
        }
        Byte[] bytes = new Byte[elements.length];
        int l = bytes.length;
        for (int i = 0; i < l; ++i) {
            bytes[i] = elements[i];
        }
        return SearchableHelper.indexOf(searchable, fromIndex, toIndex, bytes);
    }
}

