/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.coodex.util.SPI;
import org.coodex.util.ServiceLoader;

public class ServiceLoaderHelper {
    public static <T> List<T> sort(ServiceLoader<T> serviceLoader, Comparator<? super T> comparator) {
        Map<String, T> map = serviceLoader.getAll();
        ArrayList<T> sorted = new ArrayList<T>();
        if (map != null) {
            sorted.addAll(map.values());
            Collections.sort(sorted, comparator);
        }
        return sorted;
    }

    public static <T> List<T> sort(ServiceLoader<T> serviceLoader) {
        return ServiceLoaderHelper.sort(serviceLoader, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return SPI.getServiceOrder(o1) - SPI.getServiceOrder(o2);
            }
        });
    }
}

